/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockLeavesBase;
import shetiphian.terraqueous.common.item.ItemBlockLeaves;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockLeavesBanana
extends BlockLeavesBase {
    public static final EnumProperty<EnumType> VARIANT = EnumProperty.func_177709_a((String)"variant", EnumType.class);
    private static final VoxelShape SHAPE_STALK_BARE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_STALK = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final ResourceLocation TAG_BANANA_LOGS = new ResourceLocation("terraqueous:banana_logs");

    public BlockLeavesBanana(PlantAPI.TreeType treeType) {
        super(treeType);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(VARIANT, (Comparable)((Object)EnumType.NORMAL)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{VARIANT});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case NORMAL: {
                return VoxelShapes.func_197868_b();
            }
            case STALK_BARE: {
                return SHAPE_STALK_BARE;
            }
        }
        return SHAPE_STALK;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!world.field_72995_K && state.func_177229_b(VARIANT) != EnumType.NORMAL && world.func_175623_d(pos.func_177984_a())) {
            world.func_175655_b(pos, true);
        }
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
    }

    public boolean canGrow(World world, BlockPos pos, BlockState state, boolean isClient) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case NORMAL: {
                return this.flowerCheck(world, pos);
            }
            case FLOWER: {
                BlockState upState;
                if (world.func_175623_d(pos.func_177977_b()) && (upState = world.func_180495_p(pos.func_177984_a())).func_177230_c() == this && upState.func_177229_b(VARIANT) != EnumType.STALK_BARE) {
                    for (Direction facing : Direction.Plane.HORIZONTAL) {
                        BlockPos sPos = pos.func_177967_a(facing, 2);
                        BlockState sState = world.func_180495_p(sPos.func_177977_b());
                        if (sState.func_196958_f() || !sState.func_177230_c().getTags().contains(TAG_BANANA_LOGS)) continue;
                        return true;
                    }
                }
                return false;
            }
            case STALK_BARE: 
            case STALK_GROW: {
                return world.func_180495_p(pos.func_177984_a()).func_177230_c() == this && (world.func_175623_d(pos.func_177977_b()) || world.func_180495_p(pos.func_177977_b()).func_177230_c() == this);
            }
            case FRUIT: {
                return world.func_175623_d(pos.func_177977_b()) && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
            }
        }
        return false;
    }

    private boolean isBananaLeaf(BlockState state) {
        return state.func_177230_c() == this && state.func_177229_b(VARIANT) == EnumType.NORMAL;
    }

    private boolean flowerCheck(World world, BlockPos pos) {
        if (world.func_175623_d(pos.func_177977_b())) {
            BlockPos sPos;
            BlockState sState;
            BlockPos woodPos = pos;
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                if (!this.isBananaLeaf(world.func_180495_p(pos.func_177972_a(facing))) || (sState = world.func_180495_p(sPos = pos.func_177967_a(facing, 2))).func_196958_f() || !sState.func_177230_c().getTags().contains(TAG_BANANA_LOGS)) continue;
                woodPos = sPos;
                break;
            }
            if (woodPos != pos && this.isBananaLeaf(sState = world.func_180495_p(woodPos.func_177984_a()))) {
                boolean noFlower = true;
                for (Direction facing : Direction.Plane.HORIZONTAL) {
                    sPos = woodPos.func_177967_a(facing, 2);
                    sState = world.func_180495_p(sPos.func_177977_b());
                    if (sState.func_177230_c() != this || sState.func_177229_b(VARIANT) == EnumType.NORMAL) continue;
                    noFlower = false;
                    break;
                }
                return noFlower;
            }
        }
        return false;
    }

    public boolean canUseBonemeal(World world, Random random, BlockPos pos, BlockState state) {
        return (state.func_177229_b(VARIANT) != EnumType.FRUIT || world.func_175623_d(pos.func_177977_b())) && random.nextFloat() < 0.45f;
    }

    public void grow(World world, Random rand, BlockPos pos, BlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        switch (type) {
            case NORMAL: 
            case FRUIT: {
                if (!world.func_175623_d(pos.func_177977_b())) break;
                Function.setBlock((IWorld)world, (BlockPos)pos.func_177977_b(), (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.FLOWER))), (boolean)true);
                break;
            }
            case FLOWER: {
                BlockState upState;
                if (!world.func_175623_d(pos.func_177977_b()) || (upState = world.func_180495_p(pos.func_177984_a())).func_177230_c() != this || upState.func_177229_b(VARIANT) == EnumType.STALK_BARE) break;
                Function.setBlock((IWorld)world, (BlockPos)pos.func_177977_b(), (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.FLOWER))), (boolean)true);
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.STALK_BARE))), (boolean)true);
                break;
            }
            case STALK_BARE: 
            case STALK_GROW: {
                if (world.func_175623_d(pos.func_177977_b())) {
                    Function.setBlock((IWorld)world, (BlockPos)pos.func_177977_b(), (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.FLOWER))), (boolean)true);
                    break;
                }
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)(type == EnumType.STALK_BARE ? EnumType.STALK_GROW : EnumType.FRUIT)))), (boolean)true);
            }
        }
    }

    @Override
    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (state.func_177229_b(VARIANT) == EnumType.NORMAL) {
            super.func_225542_b_(state, world, pos, random);
        }
        if (!world.func_175623_d(pos) && this.canGrow((World)world, pos, state, world.field_72995_K)) {
            switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
                case NORMAL: 
                case FLOWER: 
                case FRUIT: {
                    if (!world.func_175623_d(pos.func_177977_b())) break;
                    this.grow((World)world, random, pos, state);
                    break;
                }
                case STALK_BARE: {
                    if (!world.func_175623_d(pos.func_177977_b()) && !PlantFunctions.growFruitFlower((IBlockReader)world, pos, PlantAPI.TreeType.BANANA)) break;
                    this.grow((World)world, random, pos, state);
                    break;
                }
                case STALK_GROW: {
                    if (!world.func_175623_d(pos.func_177977_b()) && !PlantFunctions.growFruit((IBlockReader)world, pos, PlantAPI.TreeType.BANANA)) break;
                    this.grow((World)world, random, pos, state);
                }
            }
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        ItemStack stack = context.func_195996_i();
        if (state != null && stack.func_77973_b() instanceof ItemBlockLeaves) {
            state = (BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.byValue(ItemBlockLeaves.getType(stack))));
        }
        return state;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemBlockLeaves.create(this.treeType, ((EnumType)((Object)state.func_177229_b(VARIANT))).getValue());
    }

    public static BlockState getFlowerVariant(BlockState state) {
        if (state.func_177230_c() instanceof BlockLeavesBanana) {
            state = (BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.FLOWER));
        }
        return state;
    }

    public static enum EnumType implements IStringSerializable
    {
        NORMAL(0),
        FLOWER(1),
        STALK_BARE(2),
        STALK_GROW(3),
        FRUIT(4);

        private static final EnumType[] array;
        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            return array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[5];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

