/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.IColored;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.misc.FoliageColor;
import shetiphian.terraqueous.client.render.RenderRegistry;

public abstract class BlockLeavesBase
extends Block
implements IBonemealable,
IColored {
    public static final IntegerProperty DISTANCE = BlockStateProperties.field_208514_aa;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.field_208515_s;
    protected final PlantAPI.TreeType treeType;

    public BlockLeavesBase(PlantAPI.TreeType treeType) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c).func_226896_b_().func_235842_b_((state, world, pos) -> false).func_235847_c_((state, world, pos) -> false).func_235827_a_(BlockLeavesBase::canEntitySpawn));
        this.treeType = treeType;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(7))).func_206870_a((Property)PERSISTENT, (Comparable)Boolean.FALSE));
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DISTANCE, PERSISTENT});
    }

    public PlantAPI.TreeType getTreeType() {
        return this.treeType;
    }

    public int func_200011_d(BlockState state, IBlockReader world, BlockPos pos) {
        return 1;
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!((Boolean)state.func_177229_b((Property)PERSISTENT)).booleanValue() && (Integer)state.func_177229_b((Property)DISTANCE) == 7) {
            BlockLeavesBase.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
            world.func_217377_a(pos, false);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        world.func_180501_a(pos, BlockLeavesBase.updateDistance(state, (IWorld)world, pos), 3);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        int i = BlockLeavesBase.getDistance(facingState) + 1;
        if (i != 1 || (Integer)state.func_177229_b((Property)DISTANCE) != i) {
            world.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return state;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return BlockLeavesBase.updateDistance((BlockState)this.func_176223_P().func_206870_a((Property)PERSISTENT, (Comparable)Boolean.TRUE), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    private static BlockState updateDistance(BlockState state, IWorld world, BlockPos pos) {
        int i = 7;
        BlockPos.Mutable mPos = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            mPos.func_189533_g((Vector3i)pos).func_189536_c(direction);
            i = Math.min(i, BlockLeavesBase.getDistance(world.func_180495_p((BlockPos)mPos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistance(BlockState neighbor) {
        if (BlockTags.field_200031_h.func_230235_a_((Object)neighbor.func_177230_c())) {
            return 0;
        }
        return BlockTags.field_206952_E.func_230235_a_((Object)neighbor.func_177230_c()) ? (Integer)neighbor.func_177229_b((Property)DISTANCE) : 7;
    }

    public static boolean canEntitySpawn(BlockState state, IBlockReader world, BlockPos pos, EntityType<?> type) {
        return type == EntityType.field_200781_U || type == EntityType.field_200783_W;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!world.func_175727_C(pos.func_177984_a()) || rand.nextInt(15) != 1 || (blockstate = world.func_180495_p(blockpos = pos.func_177977_b())).func_200132_m() && blockstate.func_224755_d((IBlockReader)world, blockpos, Direction.UP))) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_195594_a((IParticleData)ParticleTypes.field_197618_k, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index == 0) {
            if (data.world != null && data.pos != null) {
                return FoliageColor.getBiomeColor(data.world, data.pos, FoliageColor.EnumFoliage.getFoliage(this.treeType));
            }
            return FoliageColor.getRenderColor(FoliageColor.EnumFoliage.getFoliage(this.treeType));
        }
        return 0xFFFFFF;
    }
}

