/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.common.block.BlockPergola;
import shetiphian.terraqueous.common.block.BlockPergolaGate;

public class BlockPergolaWall
extends BlockPergola {
    public static final EnumProperty<BlockPergola.EnumStyle> NORTH = EnumProperty.func_177709_a((String)"north", BlockPergola.EnumStyle.class);
    public static final EnumProperty<BlockPergola.EnumStyle> EAST = EnumProperty.func_177709_a((String)"east", BlockPergola.EnumStyle.class);
    public static final EnumProperty<BlockPergola.EnumStyle> SOUTH = EnumProperty.func_177709_a((String)"south", BlockPergola.EnumStyle.class);
    public static final EnumProperty<BlockPergola.EnumStyle> WEST = EnumProperty.func_177709_a((String)"west", BlockPergola.EnumStyle.class);
    public static final EnumProperty<BlockPergola.EnumStyle> POST = EnumProperty.func_177709_a((String)"post", BlockPergola.EnumStyle.class);
    protected static final VoxelShape SHAPE_NN = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)6.9, (double)1.9, (double)0.0, (double)9.1, (double)4.1, (double)8.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.9, (double)11.9, (double)0.0, (double)9.1, (double)14.1, (double)8.0), Block.func_208617_a((double)7.7, (double)4.0, (double)0.0, (double)8.3, (double)12.0, (double)8.0)});
    protected static final VoxelShape SHAPE_EN = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)8.0, (double)1.9, (double)6.9, (double)16.0, (double)4.1, (double)9.1), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)8.0, (double)11.9, (double)6.9, (double)16.0, (double)14.1, (double)9.1), Block.func_208617_a((double)8.0, (double)4.0, (double)7.7, (double)16.0, (double)12.0, (double)8.3)});
    protected static final VoxelShape SHAPE_SN = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)6.9, (double)1.9, (double)8.0, (double)9.1, (double)4.1, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.9, (double)11.9, (double)8.0, (double)9.1, (double)14.1, (double)16.0), Block.func_208617_a((double)7.7, (double)4.0, (double)8.0, (double)8.3, (double)12.0, (double)16.0)});
    protected static final VoxelShape SHAPE_WN = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)1.9, (double)6.9, (double)8.0, (double)4.1, (double)9.1), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)11.9, (double)6.9, (double)8.0, (double)14.1, (double)9.1), Block.func_208617_a((double)0.0, (double)4.0, (double)7.7, (double)8.0, (double)12.0, (double)8.3)});
    protected static final VoxelShape SHAPE_NT = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.9, (double)11.9, (double)0.0, (double)9.1, (double)14.1, (double)8.0), (VoxelShape)Block.func_208617_a((double)7.7, (double)0.0, (double)0.0, (double)8.3, (double)12.0, (double)8.0));
    protected static final VoxelShape SHAPE_ET = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)8.0, (double)11.9, (double)6.9, (double)16.0, (double)14.1, (double)9.1), (VoxelShape)Block.func_208617_a((double)8.0, (double)0.0, (double)7.7, (double)16.0, (double)12.0, (double)8.3));
    protected static final VoxelShape SHAPE_ST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.9, (double)11.9, (double)8.0, (double)9.1, (double)14.1, (double)16.0), (VoxelShape)Block.func_208617_a((double)7.7, (double)0.0, (double)8.0, (double)8.3, (double)12.0, (double)16.0));
    protected static final VoxelShape SHAPE_WT = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)11.9, (double)6.9, (double)8.0, (double)14.1, (double)9.1), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)7.7, (double)8.0, (double)12.0, (double)8.3));
    protected static final VoxelShape SHAPE_NM = Block.func_208617_a((double)7.7, (double)0.0, (double)0.0, (double)8.3, (double)16.0, (double)8.0);
    protected static final VoxelShape SHAPE_EM = Block.func_208617_a((double)8.0, (double)0.0, (double)7.7, (double)16.0, (double)16.0, (double)8.3);
    protected static final VoxelShape SHAPE_SM = Block.func_208617_a((double)7.7, (double)0.0, (double)8.0, (double)8.3, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WM = Block.func_208617_a((double)0.0, (double)0.0, (double)7.7, (double)8.0, (double)16.0, (double)8.3);
    protected static final VoxelShape SHAPE_NB = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.9, (double)1.9, (double)0.0, (double)9.1, (double)4.1, (double)8.0), (VoxelShape)Block.func_208617_a((double)7.7, (double)4.0, (double)0.0, (double)8.3, (double)16.0, (double)8.0));
    protected static final VoxelShape SHAPE_EB = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)8.0, (double)1.9, (double)6.9, (double)16.0, (double)4.1, (double)9.1), (VoxelShape)Block.func_208617_a((double)8.0, (double)4.0, (double)7.7, (double)16.0, (double)16.0, (double)8.3));
    protected static final VoxelShape SHAPE_SB = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.9, (double)1.9, (double)8.0, (double)9.1, (double)4.1, (double)16.0), (VoxelShape)Block.func_208617_a((double)7.7, (double)4.0, (double)8.0, (double)8.3, (double)16.0, (double)16.0));
    protected static final VoxelShape SHAPE_WB = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)1.9, (double)6.9, (double)8.0, (double)4.1, (double)9.1), (VoxelShape)Block.func_208617_a((double)0.0, (double)4.0, (double)7.7, (double)8.0, (double)16.0, (double)8.3));
    protected static final VoxelShape SHAPE_PN = Block.func_208617_a((double)5.9, (double)0.0, (double)5.9, (double)10.1, (double)16.0, (double)10.1);
    protected static final VoxelShape SHAPE_PT = Block.func_208617_a((double)5.9, (double)9.9, (double)5.9, (double)10.1, (double)16.0, (double)10.1);
    protected static final VoxelShape SHAPE_PB = Block.func_208617_a((double)5.9, (double)0.0, (double)5.9, (double)10.1, (double)6.1, (double)10.1);
    private static final Map<String, VoxelShape> SHAPE_CACHE = new HashMap<String, VoxelShape>();

    public BlockPergolaWall() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(NORTH, (Comparable)((Object)BlockPergola.EnumStyle.NONE))).func_206870_a(EAST, (Comparable)((Object)BlockPergola.EnumStyle.NONE))).func_206870_a(SOUTH, (Comparable)((Object)BlockPergola.EnumStyle.NONE))).func_206870_a(WEST, (Comparable)((Object)BlockPergola.EnumStyle.NONE))).func_206870_a(POST, (Comparable)((Object)BlockPergola.EnumStyle.NONE)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, POST});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        String key = state.toString();
        if (SHAPE_CACHE.containsKey(key)) {
            return SHAPE_CACHE.get(key);
        }
        VoxelShape shape = VoxelShapes.func_197880_a();
        switch ((BlockPergola.EnumStyle)((Object)state.func_177229_b(NORTH))) {
            case NORMAL: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_NN);
                break;
            }
            case TOP: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_NT);
                break;
            }
            case MIDDLE: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_NM);
                break;
            }
            case BOTTOM: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_NB);
            }
        }
        switch ((BlockPergola.EnumStyle)((Object)state.func_177229_b(EAST))) {
            case NORMAL: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_EN);
                break;
            }
            case TOP: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_ET);
                break;
            }
            case MIDDLE: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_EM);
                break;
            }
            case BOTTOM: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_EB);
            }
        }
        switch ((BlockPergola.EnumStyle)((Object)state.func_177229_b(SOUTH))) {
            case NORMAL: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_SN);
                break;
            }
            case TOP: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_ST);
                break;
            }
            case MIDDLE: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_SM);
                break;
            }
            case BOTTOM: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_SB);
            }
        }
        switch ((BlockPergola.EnumStyle)((Object)state.func_177229_b(WEST))) {
            case NORMAL: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_WN);
                break;
            }
            case TOP: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_WT);
                break;
            }
            case MIDDLE: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_WM);
                break;
            }
            case BOTTOM: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_WB);
            }
        }
        switch ((BlockPergola.EnumStyle)((Object)state.func_177229_b(POST))) {
            case NORMAL: 
            case MIDDLE: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_PN);
                break;
            }
            case TOP: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_PT);
                break;
            }
            case BOTTOM: {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_PB);
            }
        }
        SHAPE_CACHE.put(key, shape);
        return shape;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        BlockPergola.EnumStyle post;
        ItemStack heldItem;
        if (hit.func_216354_b() == Direction.UP && (heldItem = player.func_184586_b(hand)).func_77973_b() instanceof BlockItem && (post = this.adjustedPostForBlock((BlockPergola.EnumStyle)((Object)state.func_177229_b(POST)), ((BlockItem)heldItem.func_77973_b()).func_179223_d())) != state.func_177229_b(POST)) {
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(POST, (Comparable)((Object)post))), (boolean)true);
            return ActionResultType.PASS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getConnectedState(this.func_176223_P(), context.func_195991_k(), context.func_195995_a());
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockState updated = this.getConnectedState(state, world, pos);
        if (state != updated) {
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)updated, (boolean)true);
        }
    }

    private BlockState getConnectedState(BlockState state, World world, BlockPos pos) {
        boolean uCon = this.shouldConnect(world, pos, Direction.UP, false);
        boolean dCon = this.shouldConnect(world, pos, Direction.DOWN, true);
        BlockPergola.EnumStyle north = this.getStyle(world, pos, Direction.NORTH, uCon, dCon);
        BlockPergola.EnumStyle south = this.getStyle(world, pos, Direction.SOUTH, uCon, dCon);
        BlockPergola.EnumStyle east = this.getStyle(world, pos, Direction.EAST, uCon, dCon);
        BlockPergola.EnumStyle west = this.getStyle(world, pos, Direction.WEST, uCon, dCon);
        BlockPergola.EnumStyle post = BlockPergola.EnumStyle.NORMAL;
        if (east == west && north == south && east != north && (east == BlockPergola.EnumStyle.NONE || north == BlockPergola.EnumStyle.NONE)) {
            post = BlockPergola.EnumStyle.NONE;
        }
        if (post == BlockPergola.EnumStyle.NORMAL && (north == BlockPergola.EnumStyle.MIDDLE || south == BlockPergola.EnumStyle.MIDDLE || east == BlockPergola.EnumStyle.MIDDLE || west == BlockPergola.EnumStyle.MIDDLE)) {
            boolean isEW;
            boolean isNS = north != BlockPergola.EnumStyle.NONE && south != BlockPergola.EnumStyle.NONE && east == BlockPergola.EnumStyle.NONE && west == BlockPergola.EnumStyle.NONE;
            boolean bl = isEW = north == BlockPergola.EnumStyle.NONE && south == BlockPergola.EnumStyle.NONE && east != BlockPergola.EnumStyle.NONE && west != BlockPergola.EnumStyle.NONE;
            if (isNS && north != BlockPergola.EnumStyle.NORMAL && south != BlockPergola.EnumStyle.NORMAL || isEW && east != BlockPergola.EnumStyle.NORMAL && west != BlockPergola.EnumStyle.NORMAL) {
                boolean anyBottom;
                boolean anyTop = north == BlockPergola.EnumStyle.TOP || south == BlockPergola.EnumStyle.TOP || east == BlockPergola.EnumStyle.TOP || west == BlockPergola.EnumStyle.TOP;
                boolean bl2 = anyBottom = north == BlockPergola.EnumStyle.BOTTOM || south == BlockPergola.EnumStyle.BOTTOM || east == BlockPergola.EnumStyle.BOTTOM || west == BlockPergola.EnumStyle.BOTTOM;
                post = !anyTop ? BlockPergola.EnumStyle.BOTTOM : (!anyBottom ? BlockPergola.EnumStyle.TOP : post);
            } else {
                post = BlockPergola.EnumStyle.MIDDLE;
            }
        }
        if (post == BlockPergola.EnumStyle.NONE) {
            if (this.getPostStyle(world, pos.func_177984_a()) == BlockPergola.EnumStyle.NORMAL) {
                post = this.getPostStyle(world, pos.func_177977_b()) == BlockPergola.EnumStyle.NORMAL ? BlockPergola.EnumStyle.MIDDLE : BlockPergola.EnumStyle.TOP;
            } else if (this.getPostStyle(world, pos.func_177977_b()) == BlockPergola.EnumStyle.NORMAL) {
                post = BlockPergola.EnumStyle.BOTTOM;
            }
        }
        post = this.adjustedPostForBlock(post, world.func_180495_p(pos.func_177984_a()).func_177230_c());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, (Comparable)((Object)north))).func_206870_a(SOUTH, (Comparable)((Object)south))).func_206870_a(EAST, (Comparable)((Object)east))).func_206870_a(WEST, (Comparable)((Object)west))).func_206870_a(POST, (Comparable)((Object)post));
    }

    private BlockPergola.EnumStyle getStyle(World world, BlockPos pos, Direction direction, boolean uCon, boolean dCon) {
        if (this.shouldConnect(world, pos, direction, true)) {
            if (uCon && this.shouldConnect(world, pos.func_177984_a(), direction, true)) {
                if (dCon && this.shouldConnect(world, pos.func_177977_b(), direction, true)) {
                    return BlockPergola.EnumStyle.MIDDLE;
                }
                return BlockPergola.EnumStyle.BOTTOM;
            }
            if (dCon && this.shouldConnect(world, pos.func_177977_b(), direction, true)) {
                return BlockPergola.EnumStyle.TOP;
            }
            return BlockPergola.EnumStyle.NORMAL;
        }
        return BlockPergola.EnumStyle.NONE;
    }

    private boolean shouldConnect(World world, BlockPos pos, Direction direction, boolean accept_gate) {
        BlockState state = world.func_180495_p(pos.func_177972_a(direction));
        if (state.func_177230_c() instanceof BlockPergolaWall) {
            return true;
        }
        if (accept_gate && state.func_177230_c() instanceof BlockPergolaGate && direction != Direction.UP) {
            Direction.Axis gate = ((Direction)state.func_177229_b((Property)BlockPergolaGate.FACING)).func_176746_e().func_176740_k();
            if (direction == Direction.DOWN) {
                if (((Boolean)state.func_177229_b((Property)BlockPergolaGate.GATE_DOWN)).booleanValue()) {
                    BlockPos down = pos.func_177977_b();
                    if (gate == Direction.Axis.X) {
                        return world.func_180495_p(down.func_177974_f()).func_177230_c() instanceof BlockPergolaWall || world.func_180495_p(down.func_177976_e()).func_177230_c() instanceof BlockPergolaWall;
                    }
                    return world.func_180495_p(down.func_177978_c()).func_177230_c() instanceof BlockPergolaWall || world.func_180495_p(down.func_177968_d()).func_177230_c() instanceof BlockPergolaWall;
                }
                return false;
            }
            return gate == direction.func_176740_k();
        }
        return false;
    }

    private BlockPergola.EnumStyle getPostStyle(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockPergolaWall) {
            return (BlockPergola.EnumStyle)((Object)state.func_177229_b(POST));
        }
        return BlockPergola.EnumStyle.NONE;
    }

    private BlockPergola.EnumStyle adjustedPostForBlock(BlockPergola.EnumStyle post, Block blockAbove) {
        if (blockAbove instanceof LanternBlock || blockAbove instanceof TorchBlock) {
            post = post == BlockPergola.EnumStyle.NONE ? BlockPergola.EnumStyle.TOP : (post == BlockPergola.EnumStyle.BOTTOM ? BlockPergola.EnumStyle.NORMAL : post);
        }
        return post;
    }
}

