/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import shetiphian.terraqueous.api.cloud.CloudPresets;
import shetiphian.terraqueous.api.cloud.ICloud;
import shetiphian.terraqueous.common.tileentity.TileEntitySign;

public class BlockPostSign {

    public static class Cloud
    extends StandingSignBlock
    implements ICloud {
        public Cloud(MaterialColor color) {
            super(CloudPresets.properties(color).func_200942_a().func_200943_b(0.3f), WoodType.field_227038_a_);
        }

        public TileEntity func_196283_a_(IBlockReader world) {
            return new TileEntitySign();
        }

        public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return CloudPresets.isFlammable();
        }

        public PushReaction func_149656_h(BlockState state) {
            return CloudPresets.getPushReaction();
        }

        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
            if (context == ISelectionContext.func_216377_a() || CloudPresets.shouldCollide(state, world, pos, context.getEntity())) {
                return super.func_220071_b(state, world, pos, context);
            }
            return VoxelShapes.func_197880_a();
        }

        public void func_176199_a(World world, BlockPos pos, Entity entity) {
            CloudPresets.onEntityWalking(world, pos, entity);
        }

        public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
            CloudPresets.onEntityCollision(state, world, pos, entity);
        }

        public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
            CloudPresets.onFallenUpon(world, pos, entity, fallDistance);
        }

        @Override
        public boolean isCloudBlock(BlockState state, IBlockReader world, BlockPos pos) {
            return true;
        }

        @Override
        public boolean isCloudKickable(BlockState state, IBlockReader world, BlockPos pos) {
            return false;
        }
    }

    public static class Wood
    extends StandingSignBlock {
        public Wood(MaterialColor color) {
            super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a), WoodType.field_227038_a_);
        }

        public TileEntity func_196283_a_(IBlockReader world) {
            return new TileEntitySign();
        }
    }
}

