/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import shetiphian.core.common.IColored;
import shetiphian.core.common.Materials;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.inventory.ContainerProviders;
import shetiphian.terraqueous.common.misc.StormForgeHelper;
import shetiphian.terraqueous.common.tileentity.TileEntitySFController;
import shetiphian.terraqueous.common.tileentity.TileEntitySFStatic;

public class BlockStormForge
extends Block
implements IColored {
    private static final Material MATERIAL = new Materials.Builder(MaterialColor.field_151665_m).setPushReaction(PushReaction.IGNORE).build();
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<StormForgeBlock> PART = EnumProperty.func_177709_a((String)"part", StormForgeBlock.class);

    public BlockStormForge() {
        super(AbstractBlock.Properties.func_200945_a((Material)MATERIAL).func_200948_a(-1.0f, 3600000.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(0).func_226896_b_().func_235861_h_());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, PART});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return state.func_177229_b(PART) == StormForgeBlock.ALTER ? new TileEntitySFController() : new TileEntitySFStatic();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tile;
        if (!world.field_72995_K && state.func_177229_b(PART) == StormForgeBlock.ALTER && (tile = world.func_175625_s(pos)) instanceof TileEntitySFController) {
            ((TileEntitySFController)tile).dropExp();
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProviders.StormForge((TileEntitySFController)tile), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        return state.func_177229_b(PART) == StormForgeBlock.ALTER ? 5.0f : -1.0f;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return false;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    private boolean isAlter(BlockState state) {
        return state.func_177230_c() instanceof BlockStormForge && state.func_177229_b(PART) == StormForgeBlock.ALTER;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177230_c() instanceof BlockStormForge ? ((StormForgeBlock)((Object)state.func_177229_b(PART))).getLightValue() : 0;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile;
        if (this.isAlter(state) && !this.isAlter(newState) && (tile = world.func_175625_s(pos)) instanceof TileEntitySFController) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            ((TileEntitySFController)tile).addExtraDrops(drops);
            drops.forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
            StormForgeHelper.removeStormForge(world, pos);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public int getColorFor(IColored.Data data, int index) {
        if (index == 1 && data.world != null && data.pos != null) {
            return BiomeColors.func_228363_c_((IBlockDisplayReader)data.world, (BlockPos)data.pos);
        }
        return 0xFFFFFF;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)Values.itemStormScroll);
    }

    public static enum StormForgeBlock implements IStringSerializable
    {
        ALTER(0),
        MONOLITH(0),
        MONOLITH_SMOOTH(0),
        MONOLITH_HIGHPEAK(0),
        MONOLITH_LOWPEAK(0),
        PLATFORM_ALTER_AQUADUCT(2),
        PLATFORM_AQUADUCT(2),
        PLATFORM_AQUADUCT_TEE(2),
        PLATFORM_EDGE(1),
        PLATFORM_MONOLITH_AQUADUCT(2),
        PLATFORM_MONOLITH_CORNER(1),
        PLATFORM_MONOLITH_EDGE(1),
        PLATFORM_RUNE(1);

        private final int lightValue;

        private StormForgeBlock(int lightValue) {
            this.lightValue = lightValue;
        }

        public int getLightValue() {
            return this.lightValue;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

