/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.render.RenderRegistry;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockTallGrass
extends TallGrassBlock
implements IColored {
    public BlockTallGrass() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151582_l).func_200942_a().func_200944_c().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c).func_222379_b(Blocks.field_150349_c));
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (world.field_72995_K || !world.func_72935_r()) {
            return;
        }
        if (PlantFunctions.canSpread((World)world, pos, PlantAPI.PlantType.GRASS) && Function.getBlockDown((IBlockReader)world, (BlockPos)pos) != Values.blockPlanter) {
            this.spreadGrass((World)world, pos, state, random);
        } else if (PlantFunctions.canGrow((World)world, pos, PlantAPI.PlantType.GRASS)) {
            super.func_225535_a_(world, random, pos, state);
        }
    }

    private void spreadGrass(World world, BlockPos pos, BlockState state, Random random) {
        byte maxAttempts = PlantFunctions.getMaxPlacementAttempts((IBlockReader)world, pos, PlantAPI.PlantType.GRASS);
        byte[] spreadRadius = PlantFunctions.getSpreadRadius((IBlockReader)world, pos, PlantAPI.PlantType.GRASS);
        for (byte attempt = 0; attempt < maxAttempts; attempt = (byte)(attempt + 1)) {
            BlockPos sPos = pos.func_177982_a(this.getOffset(spreadRadius[0], random), this.getOffset(spreadRadius[1], random), this.getOffset(spreadRadius[0], random));
            BlockState sState = world.func_180495_p(sPos);
            if (sState.isAir((IBlockReader)world, sPos) && this.func_196260_a(sState, (IWorldReader)world, sPos) && this.canSpreadHere(world, sPos)) {
                Function.setBlock((IWorld)world, (BlockPos)sPos, (BlockState)state, (boolean)true);
                return;
            }
            pos = sPos;
        }
    }

    private int getOffset(int spreadRadius, Random random) {
        return random.nextInt(spreadRadius) - random.nextInt(spreadRadius);
    }

    private boolean canSpreadHere(World world, BlockPos pos) {
        if (Values.blockPlanter != null && Function.getBlockDown((IBlockReader)world, (BlockPos)pos) == Values.blockPlanter) {
            return false;
        }
        int touching = 0;
        int total = 0;
        int air = 0;
        for (int sX = -1; sX < 2; ++sX) {
            for (int sZ = -1; sZ < 2; ++sZ) {
                if (sX == 0 && sZ == 0) continue;
                BlockPos sPos = pos.func_177982_a(sX, 0, sZ);
                if (world.func_180495_p(sPos).func_177230_c() == this) {
                    total = (byte)(total + 1);
                    if (sX == 0 || sZ == 0) {
                        touching = (byte)(touching + 1);
                    }
                }
                if (!world.func_175623_d(sPos)) continue;
                air = (byte)(air + 1);
            }
        }
        return touching < 2 && total < 2 && air > 4;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (Function.getBlockDown((IBlockReader)world, (BlockPos)pos) == Values.blockPlanter) {
            return true;
        }
        Biome biome = world.func_226691_t_(pos);
        if (BiomeDictionary.hasAnyType((Biome)biome) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return false;
        }
        return Function.getBlockDown((IBlockReader)world, (BlockPos)pos) != Blocks.field_150458_ak && super.func_196260_a(state, world, pos);
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return Tags.Blocks.DIRT.func_230235_a_((Object)state.func_177230_c()) || state.func_177230_c() == Blocks.field_196658_i || state.func_177230_c() == Values.blockPlanter;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)Item.func_150898_a((Block)Blocks.field_196804_gh));
    }

    public int getColorFor(IColored.Data data, int index) {
        return Minecraft.func_71410_x().func_184125_al().func_228054_a_(Blocks.field_196804_gh.func_176223_P(), data.world, data.pos, index);
    }
}

