/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.common.misc.StormForgeHelper;

public class StormForgeCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"repair_stormforge").requires(StormForgeCommand::canUse)).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(StormForgeCommand::execute))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(StormForgeCommand::execute))).executes(StormForgeCommand::execute));
    }

    private static boolean canUse(CommandSource source) {
        Configuration.Menu_StormForge.LEVEL level = (Configuration.Menu_StormForge.LEVEL)((Object)Configuration.STORMFORGE.permissions.get());
        if (level != Configuration.Menu_StormForge.LEVEL.NO_ONE) {
            Entity entity;
            if (level == Configuration.Menu_StormForge.LEVEL.EVERYONE) {
                return true;
            }
            if (source != null && (entity = source.func_197022_f()) instanceof PlayerEntity) {
                return level.check((PlayerEntity)entity);
            }
        }
        return false;
    }

    public static int execute(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        ServerWorld world = source.func_197023_e();
        ServerPlayerEntity sender = null;
        try {
            sender = source.func_197035_h();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BlockPos pos = null;
        try {
            pos = Vec3Argument.func_200385_b(context, (String)"location").func_197280_c(source);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pos == null) {
            try {
                Entity entity = EntityArgument.func_197088_a(context, (String)"target");
                pos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_() - 1.0, entity.func_226281_cx_());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pos == null && sender != null) {
            pos = new BlockPos(sender.func_226277_ct_(), sender.func_226278_cu_() - 1.0, sender.func_226281_cx_());
        }
        if (pos != null) {
            if (StormForgeHelper.repairStormForge((World)world, pos)) {
                StormForgeCommand.sendMessage(sender, "command.terraqueous.stormforge.fixed.txt");
                return 1;
            }
            StormForgeCommand.sendMessage(sender, "command.terraqueous.stormforge.nofix.txt");
        }
        StormForgeCommand.sendMessage(sender, "command.terraqueous.stormforge.help.txt");
        return 0;
    }

    private static void sendMessage(ServerPlayerEntity sender, String message) {
        if (sender != null) {
            sender.func_145747_a((ITextComponent)new TranslationTextComponent(message), sender.func_110124_au());
        }
    }
}

