/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.IColored;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.terraqueous.client.render.RenderRegistry;

public class ItemBlockRGB
extends BlockItem
implements IColored,
IRGB16_Item {
    private final short startColor;

    public ItemBlockRGB(Block block, Item.Properties builder, DyeColor color) {
        this(block, builder, RGB16Helper.getIndexFor((DyeColor)color));
    }

    public ItemBlockRGB(Block block, Item.Properties builder, RGB16 rgb16) {
        this(block, builder, rgb16.getIndex());
    }

    public ItemBlockRGB(Block block, Item.Properties builder, short index) {
        super(block, builder);
        this.startColor = index;
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            for (DyeColor color : DyeColor.values()) {
                list.add((Object)RGB16StackHelper.setRGB16((ItemStack)new ItemStack((IItemProvider)this), (String)color.func_176610_l()));
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        super.func_77622_d(stack, world, player);
        if (RGB16StackHelper.getRGB16((ItemStack)stack) == null) {
            RGB16StackHelper.setRGB16((ItemStack)stack, (short)this.getStartingIndex(stack));
        }
    }

    public short getRGB16(ItemStack stack) {
        return RGB16StackHelper.readColorTag((ItemStack)stack, (short)this.startColor);
    }

    public boolean setRGB16(ItemStack stack, short rgbIndex) {
        return RGB16StackHelper.writeColorTags((ItemStack)stack, (short)rgbIndex);
    }

    public int getColorFor(IColored.Data data, int index) {
        return index == 0 && !data.stack.func_190926_b() ? RGB16Helper.getColor((short)this.getRGB16(data.stack)) : 0xFFFFFF;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advancedTooltips) {
        tooltip.add((ITextComponent)new StringTextComponent(RGB16Helper.getTooltip((short)this.getRGB16(stack))));
        super.func_77624_a(stack, world, tooltip, advancedTooltips);
    }

    public short getStartingIndex(ItemStack stack) {
        return this.startColor;
    }

    public boolean enableDyeRecipe(ItemStack stack) {
        return true;
    }

    public boolean dyeUseChance(ItemStack stack) {
        return true;
    }

    public double getDyeUseChance(ItemStack result, ItemStack dye, int dyeCounter) {
        if (result.func_77973_b() == this && RGB16StackHelper.getRGB16Index((ItemStack)result) == this.getStartingIndex(result)) {
            return 1.0;
        }
        return Math.max(0.0, 1.0 - 0.15 * (double)dyeCounter);
    }
}

