/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;
import shetiphian.terraqueous.common.item.ArmorMaterial;
import shetiphian.terraqueous.modintegration.curios.Curio_Base;

public class ItemBurniumBelt
extends ArmorItem
implements ICapabilityProvider {
    @ObjectHolder(value="minecraft:efficiency")
    private static Enchantment EFFICIENCY;
    @ObjectHolder(value="minecraft:fire_protection")
    private static Enchantment FIRE_PROTECTION;

    public ItemBurniumBelt(Item.Properties builder) {
        super((IArmorMaterial)ArmorMaterial.UTILITY, EquipmentSlotType.LEGS, builder);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "terraqueous:textures/model/armor/burnium_belt.png";
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        CompoundNBT tag;
        short heat;
        if (stack.func_190926_b() || !(entity instanceof LivingEntity)) {
            return;
        }
        if (itemSlot >= 0 && itemSlot != EquipmentSlotType.LEGS.func_188454_b() && (heat = (tag = stack.func_190925_c("status")).func_74765_d("heat")) > 0) {
            ItemBurniumBelt.cooldown(stack, heat, tag);
        }
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        ItemBurniumBelt.adjustHeat(stack, (LivingEntity)player);
    }

    public static void adjustHeat(ItemStack stack, LivingEntity entity) {
        if (stack.func_190926_b()) {
            return;
        }
        CompoundNBT tag = stack.func_190925_c("status");
        short heat = tag.func_74765_d("heat");
        if (entity.func_70027_ad() || entity.func_180799_ab()) {
            if ((heat = (short)(heat + 1)) < ItemBurniumBelt.getMax(stack) + 1) {
                tag.func_74777_a("heat", heat);
                if (!entity.func_230279_az_()) {
                    entity.func_195064_c(new EffectInstance(Effects.field_76426_n, 20, 0, true, false));
                }
                entity.func_70066_B();
            }
        } else if (heat > 0) {
            ItemBurniumBelt.cooldown(stack, heat, tag);
        }
    }

    private static short getMax(ItemStack stack) {
        int max = 2400;
        if (FIRE_PROTECTION != null && !stack.func_190926_b()) {
            max += 2400 * EnchantmentHelper.func_77506_a((Enchantment)FIRE_PROTECTION, (ItemStack)stack);
        }
        return (short)Math.min(max, Short.MAX_VALUE);
    }

    private static void cooldown(ItemStack stack, short heat, CompoundNBT tag) {
        int value;
        int reduction = 1;
        if (FIRE_PROTECTION != null) {
            reduction += EnchantmentHelper.func_77506_a((Enchantment)FIRE_PROTECTION, (ItemStack)stack);
        }
        if (EFFICIENCY != null && (value = EnchantmentHelper.func_77506_a((Enchantment)EFFICIENCY, (ItemStack)stack)) > 0) {
            reduction *= value + 1;
        }
        tag.func_74777_a("heat", (short)Math.max(0, heat - reduction));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0.0;
        }
        CompoundNBT tag = stack.func_190925_c("status");
        return (double)tag.func_74765_d("heat") / (double)ItemBurniumBelt.getMax(stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return net.minecraft.item.ArmorMaterial.GOLD.func_200900_a();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == EFFICIENCY || enchantment == FIRE_PROTECTION;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return this;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        LazyOptional<T> curio = Curio_Base.INSTANCE.getCapability(capability, "burnium_belt");
        if (curio.isPresent()) {
            return curio;
        }
        return LazyOptional.empty();
    }
}

