/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import shetiphian.core.client.Localization;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.item.ItemFood;
import shetiphian.terraqueous.common.misc.DeathFruitHelper;

public class ItemEffectFood {

    public static class DeathFruit
    extends ItemFood {
        public DeathFruit(Item.Properties properties) {
            super(properties);
        }

        public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
            ItemStack result = super.func_77654_b(stack, world, entity);
            if (entity instanceof PlayerEntity) {
                ArrayList<EffectInstance> tobeRemoved = new ArrayList<EffectInstance>();
                for (EffectInstance instance : entity.func_70651_bq()) {
                    Effect effect = instance.func_188419_a();
                    if (effect == Values.effectDeathFruitCrash || effect == Values.effectDeathFruitWithdraw) {
                        tobeRemoved.add(instance);
                        continue;
                    }
                    if (instance.func_76459_b() > 300 || effect.func_220303_e() != EffectType.HARMFUL) continue;
                    tobeRemoved.add(instance);
                }
                entity.func_70651_bq().removeAll(tobeRemoved);
                if (!entity.func_130014_f_().field_72995_K) {
                    double value = DeathFruitHelper.addiction(entity, 2);
                    ModifiableAttributeInstance attTimer = entity.func_110148_a(Values.attributeDeathFruitTimer);
                    if (attTimer == null) {
                        entity.func_233645_dx_().func_233779_a_(Values.attributeDeathFruitTimer);
                        attTimer = entity.func_110148_a(Values.attributeDeathFruitTimer);
                    }
                    if (attTimer != null) {
                        attTimer.func_111128_a((double)(DeathFruitHelper.TIME_TO_CRASH + DeathFruitHelper.TIME_TO_WITHDRAW + (int)(62.0 * value)));
                    }
                    entity.func_195064_c(new EffectInstance(Effects.field_76439_r, (int)(6000.0 * value), 0, false, false));
                    entity.func_195064_c(new EffectInstance(Effects.field_76424_c, (int)(4800.0 * value), 1, false, false));
                    entity.func_195064_c(new EffectInstance(Effects.field_76430_j, (int)(4800.0 * value), 0, false, false));
                    entity.func_195064_c(new EffectInstance(Effects.field_76420_g, (int)(3600.0 * value), 2, false, false));
                }
            }
            return result;
        }

        public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advancedTooltips) {
            tooltip.add((ITextComponent)new StringTextComponent(Localization.get((String)"info.terraqueous.deathfruit.txt")));
        }
    }

    public static class LifeFruit
    extends ItemFood {
        public LifeFruit(Item.Properties properties) {
            super(properties);
        }

        public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
            ItemStack result = super.func_77654_b(stack, world, entity);
            if (entity instanceof PlayerEntity) {
                ModifiableAttributeInstance attribute = entity.func_110148_a(Attributes.field_233818_a_);
                int baseHealth = (int)attribute.func_111125_b();
                int health = (int)entity.func_110143_aJ();
                if (health < baseHealth) {
                    entity.func_195064_c(new EffectInstance(Effects.field_76432_h, 1, 0, false, false));
                    entity.func_195064_c(new EffectInstance(Effects.field_76428_l, 600, 0, false, false));
                } else if (entity.func_110139_bj() < (float)baseHealth) {
                    entity.func_110149_m(Math.min(entity.func_110139_bj() + 2.0f, (float)baseHealth));
                } else {
                    entity.func_195064_c(new EffectInstance(Effects.field_76420_g, 1200, 0, false, false));
                    entity.func_195064_c(new EffectInstance(Effects.field_76428_l, 600, 0, false, false));
                }
            }
            return result;
        }
    }
}

