/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.entity.EntityCoconut;

public class ItemSpawnFood
extends Item {
    protected final EntityType<?> entityType;

    public ItemSpawnFood(EntityType<?> entityType, Item.Properties properties) {
        super(properties);
        this.entityType = entityType;
    }

    protected boolean func_194125_a(ItemGroup group) {
        return group == ItemGroup.field_78039_h || super.func_194125_a(group);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null || player.func_213453_ef()) {
            World world = context.func_195991_k();
            if (!world.field_72995_K) {
                ItemStack stack = context.func_195996_i();
                BlockPos pos = context.func_195995_a();
                Direction direction = context.func_196000_l();
                BlockPos blockPos = world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_197766_b() ? pos : pos.func_177972_a(direction);
                Entity entity = this.getSpawnEntity(stack, world, blockPos, player);
                if (entity != null) {
                    world.func_217376_c(entity);
                    stack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (player.func_213453_ef()) {
            ItemStack stack = player.func_184586_b(hand);
            if (world.field_72995_K) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            BlockRayTraceResult traceResult = ItemSpawnFood.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
            if (traceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            BlockRayTraceResult blockRayTraceResult = traceResult;
            BlockPos pos = blockRayTraceResult.func_216350_a();
            if (!(world.func_180495_p(pos).func_177230_c() instanceof FlowingFluidBlock)) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            if (world.func_175660_a(player, pos) && player.func_175151_a(pos, blockRayTraceResult.func_216354_b(), stack)) {
                Entity entity = this.getSpawnEntity(stack, world, pos, player);
                if (entity == null) {
                    return new ActionResult(ActionResultType.PASS, (Object)stack);
                }
                world.func_217376_c(entity);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    protected Entity getSpawnEntity(ItemStack stack, World world, BlockPos pos, PlayerEntity player) {
        if (this.entityType == Values.entityCoconut) {
            return new EntityCoconut(world, pos, false);
        }
        return this.entityType.func_220331_a(world, stack, player, pos, SpawnReason.SPAWN_EGG, false, false);
    }
}

