/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import shetiphian.core.client.Localization;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.misc.InfiniteTank;
import shetiphian.terraqueous.modintegration.curios.Curio_Base;

public class ItemWaterPearl
extends Item {
    public ItemWaterPearl(Item.Properties builder) {
        super(builder);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (((Boolean)Configuration.WATER_PEARL.enableWorldInteraction.get()).booleanValue()) {
            BlockRayTraceResult raytraceresult = ItemWaterPearl.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
            ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)player, (World)world, (ItemStack)stack.func_77946_l(), (RayTraceResult)raytraceresult);
            if (ret != null) {
                return new ActionResult(ret.func_188397_a(), (Object)stack);
            }
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS || raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            BlockRayTraceResult traceResult = raytraceresult;
            BlockPos blockpos = traceResult.func_216350_a();
            if (world.func_175660_a(player, blockpos) && player.func_175151_a(blockpos, traceResult.func_216354_b(), stack)) {
                BlockPos blockpos1;
                BlockState blockstate = world.func_180495_p(blockpos);
                BlockPos blockPos = blockpos1 = blockstate.func_177230_c() instanceof ILiquidContainer ? blockpos : traceResult.func_216350_a().func_177972_a(traceResult.func_216354_b());
                if (this.tryPlaceContainedLiquid(player, world, blockpos1, traceResult)) {
                    if (player instanceof ServerPlayerEntity) {
                        CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, blockpos1, stack);
                    }
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
                }
            }
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    private boolean tryPlaceContainedLiquid(@Nullable PlayerEntity player, World world, BlockPos pos, BlockRayTraceResult traceResult) {
        if (((Boolean)Configuration.WATER_PEARL.enableWorldInteraction.get()).booleanValue()) {
            BlockState state = world.func_180495_p(pos);
            Material material = state.func_185904_a();
            boolean solid = !material.func_76220_a();
            boolean replaceable = material.func_76222_j();
            if (world.func_175623_d(pos) || solid || replaceable || state.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)state.func_177230_c()).func_204510_a((IBlockReader)world, pos, state, (Fluid)Fluids.field_204546_a)) {
                if (world.func_230315_m_().func_236040_e_()) {
                    int x = pos.func_177958_n();
                    int y = pos.func_177956_o();
                    int z = pos.func_177952_p();
                    world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                    for (int counter = 0; counter < 8; ++counter) {
                        world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
                    }
                } else if (state.func_177230_c() instanceof ILiquidContainer) {
                    if (((ILiquidContainer)state.func_177230_c()).func_204509_a((IWorld)world, pos, state, Fluids.field_204546_a.func_207204_a(false))) {
                        world.func_184133_a(player, pos, Fluids.field_204546_a.getAttributes().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    if (!world.field_72995_K && (solid || replaceable) && !material.func_76224_d()) {
                        world.func_175655_b(pos, true);
                    }
                    world.func_184133_a(player, pos, Fluids.field_204546_a.getAttributes().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    world.func_180501_a(pos, Fluids.field_204546_a.func_207188_f().func_206883_i(), 11);
                }
                return true;
            }
            return traceResult != null && this.tryPlaceContainedLiquid(player, world, traceResult.func_216350_a().func_177972_a(traceResult.func_216354_b()), null);
        }
        return false;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return new ItemStack((IItemProvider)Values.itemWaterPearl);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (itemSlot >= 0 && itemSlot <= 8) {
            ItemWaterPearl.resetAir(entity);
        }
    }

    public static void resetAir(Entity entity) {
        if (((Boolean)Configuration.WATER_PEARL.enableWaterBreathing.get()).booleanValue() && entity != null && entity.func_70090_H()) {
            entity.func_70050_g(Math.min(300, entity.func_70086_ai() + 2));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return stack.func_190926_b() ? null : new CapabilityProvider(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advancedTooltips) {
        String text = "";
        if (((Boolean)Configuration.WATER_PEARL.enableInfiniteWaterTank.get()).booleanValue()) {
            text = text + (text.isEmpty() ? "" : ", ");
            text = text + Localization.get((String)"info.terraqueous.waterpearl.tank.txt");
        }
        if (((Boolean)Configuration.WATER_PEARL.enableWorldInteraction.get()).booleanValue()) {
            text = text + (text.isEmpty() ? "" : ", ");
            text = text + Localization.get((String)"info.terraqueous.waterpearl.placement.txt");
        }
        if (!text.isEmpty()) {
            tooltip.add((ITextComponent)new StringTextComponent(Localization.get((String)"info.terraqueous.waterpearl.water.txt") + " " + text));
        }
        if (((Boolean)Configuration.WATER_PEARL.enableWaterBreathing.get()).booleanValue()) {
            tooltip.add((ITextComponent)new StringTextComponent(Localization.get((String)"info.terraqueous.waterpearl.breath.txt")));
        }
    }

    private static class CapabilityProvider
    implements ICapabilityProvider {
        private final InfiniteTank tank;

        CapabilityProvider(ItemStack stack) {
            this.tank = new InfiniteTank((Fluid)Fluids.field_204546_a, 1000).setContainer(stack);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            LazyOptional<T> curio = Curio_Base.INSTANCE.getCapability(capability, "water_pearl");
            if (curio.isPresent()) {
                return curio;
            }
            if (((Boolean)Configuration.WATER_PEARL.enableInfiniteWaterTank.get()).booleanValue() && (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                return LazyOptional.of(() -> this.tank).cast();
            }
            return LazyOptional.empty();
        }
    }
}

