/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockStormForge;
import shetiphian.terraqueous.common.tileentity.TileEntitySFStatic;

public class StormForgeHelper {
    private static final StormForgeHelper INSTANCE = new StormForgeHelper();
    public static final ITag.INamedTag<Block> TAG_ALTER_BASE = BlockTags.func_199894_a((String)"terraqueous:stormforge_alter_base");
    public static final ITag.INamedTag<Block> TAG_BURNIUM = BlockTags.func_199894_a((String)"forge:burnium");
    public static final ITag.INamedTag<Block> TAG_ENDIMIUM = BlockTags.func_199894_a((String)"forge:endimium");
    public static final ITag.INamedTag<Block> TAG_CARVED_QUARTZ = BlockTags.func_199894_a((String)"forge:quartz/carved");
    private static final SFBlock[] BLOCK_ARRAY = StormForgeHelper.populateArray();
    private static final byte[] mapSFBase = new byte[]{13, 18, 38, 38, 38, 38, 38, 18, 14, 17, 21, 36, 28, 29, 26, 34, 22, 19, 37, 33, 41, 41, 25, 41, 41, 33, 39, 37, 25, 41, 41, 33, 41, 41, 25, 39, 37, 32, 28, 36, 42, 34, 26, 30, 39, 37, 27, 41, 41, 35, 41, 41, 27, 39, 37, 35, 41, 41, 27, 41, 41, 35, 39, 17, 24, 36, 28, 31, 26, 34, 23, 19, 16, 20, 40, 40, 40, 40, 40, 20, 15};
    private static final byte[] mapSFRise = new byte[]{1, 2, -1, -1, -1, -1, -1, 1, 2, 4, 3, -1, -1, -1, -1, -1, 4, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 2, -1, -1, -1, -1, -1, 1, 2, 4, 3, -1, -1, -1, -1, -1, 4, 3};
    private static final byte[] mapSFTop = new byte[]{1, 9, -1, -1, -1, -1, -1, 10, 2, 9, 5, -1, -1, -1, -1, -1, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 12, 8, -1, -1, -1, -1, -1, 7, 11, 4, 12, -1, -1, -1, -1, -1, 11, 3};

    public static void createStormForge(World world, BlockPos pos) {
        INSTANCE.sfScanner(world, pos, EnumMode.SCAN_BUILD, true);
    }

    public static void removeStormForge(World world, BlockPos pos) {
        INSTANCE.sfScanner(world, pos, EnumMode.REMOVE, true);
    }

    public static SFBlock getSFBlock(byte sfbId) {
        sfbId = (byte)MathHelper.func_76125_a((int)sfbId, (int)0, (int)(BLOCK_ARRAY.length - 1));
        return BLOCK_ARRAY[sfbId];
    }

    public static SFBlock getSFBlockByIndex(int layer, int index) {
        layer = MathHelper.func_76125_a((int)layer, (int)0, (int)7);
        index = MathHelper.func_76125_a((int)index, (int)0, (int)80);
        byte sfbId = layer == 0 ? mapSFBase[index] : (layer > 5 ? mapSFTop[index] : mapSFRise[index]);
        if (layer == 6) {
            sfbId = sfbId > 0 && sfbId < 5 ? (byte)0 : sfbId;
        } else if (layer == 7) {
            sfbId = (byte)(sfbId == -1 || sfbId > 4 ? -1 : sfbId + 4);
        }
        return sfbId < 0 ? null : BLOCK_ARRAY[sfbId];
    }

    public static void moveFire(World world, BlockPos pos) {
        for (int sZ = -4; sZ < 5; sZ = (int)((byte)(sZ + 1))) {
            for (int sX = -4; sX < 5; sX = (int)((byte)(sX + 1))) {
                Block block;
                BlockPos place = pos.func_177982_a(sX, -1, sZ);
                int index = (sZ + 4) * 9 + (sX + 4);
                byte sfbId = mapSFBase[index];
                place = place.func_177984_a();
                if ((sfbId >= 25 && sfbId <= 32 || sfbId == 37) && ((block = world.func_180495_p(place).func_177230_c()) == Blocks.field_150480_ab || block instanceof FireBlock)) {
                    world.func_217377_a(place, false);
                }
                if (sfbId < 33 || sfbId > 36 || !world.func_175623_d(place)) continue;
                Function.setBlock((IWorld)world, (BlockPos)place, (BlockState)Blocks.field_150480_ab.func_176223_P(), (boolean)true);
            }
        }
    }

    public static void spawnLighting(ServerWorld world, BlockPos pos, boolean effectOnly) {
        LightningBoltEntity boltEntity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((World)world);
        boltEntity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)pos));
        boltEntity.func_233623_a_(effectOnly);
        world.func_217376_c((Entity)boltEntity);
    }

    private void sfScanner(World world, BlockPos pos, EnumMode mode, boolean doStrike) {
        for (int sY = -1; sY < 7; sY = (int)((byte)(sY + 1))) {
            for (int sZ = -4; sZ < 5; sZ = (int)((byte)(sZ + 1))) {
                block7: for (int sX = -4; sX < 5; sX = (int)((byte)(sX + 1))) {
                    BlockPos place = new BlockPos(pos.func_177958_n() + sX, pos.func_177956_o() + sY, pos.func_177952_p() + sZ);
                    if (place.equals((Object)pos)) continue;
                    int index = (sZ + 4) * 9 + (sX + 4);
                    byte sfbId = sY == -1 ? mapSFBase[index] : (sY > 4 ? mapSFTop[index] : mapSFRise[index]);
                    if (sY == 5) {
                        sfbId = sfbId > 0 && sfbId < 5 ? (byte)0 : sfbId;
                    } else if (sY == 6) {
                        sfbId = (byte)(sfbId == -1 || sfbId > 4 ? -1 : sfbId + 4);
                    }
                    switch (mode) {
                        case SCAN: 
                        case SCAN_BUILD: {
                            if ((sfbId < 0 || sfbId > BLOCK_ARRAY.length) && world.func_175623_d(place) || BLOCK_ARRAY[sfbId].isCorrectBlock(world.func_180495_p(place).func_177230_c())) continue block7;
                            return;
                        }
                        case BUILD: {
                            this.placeStormForgeBlock(world, place, sfbId, !(!doStrike || sX != -3 && sX != 3 || sZ != -3 && sZ != 3), pos);
                            continue block7;
                        }
                        case REMOVE: {
                            this.removeStormForgeBlock(world, place, sfbId);
                        }
                    }
                }
            }
        }
        if (mode == EnumMode.SCAN_BUILD) {
            this.sfScanner(world, pos, EnumMode.BUILD, doStrike);
        }
        if (mode == EnumMode.BUILD) {
            BlockState sfb = (BlockState)((BlockState)Values.blockStormForge.func_176223_P().func_206870_a(BlockStormForge.PART, (Comparable)((Object)BlockStormForge.StormForgeBlock.ALTER))).func_206870_a((Property)BlockStormForge.FACING, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(Function.random));
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)sfb, (boolean)false);
            if (doStrike && world instanceof ServerWorld) {
                StormForgeHelper.spawnLighting((ServerWorld)world, pos, false);
            }
        }
    }

    private void placeStormForgeBlock(World world, BlockPos pos, byte sfbId, boolean doStrike, BlockPos alter) {
        if (sfbId == -1) {
            return;
        }
        SFBlock sfb = BLOCK_ARRAY[sfbId];
        BlockState sfbs = sfb.getForgeBlock();
        Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)sfbs.func_206870_a((Property)BlockStormForge.FACING, (Comparable)sfb.getFacing())), (boolean)false);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntitySFStatic) {
            ((TileEntitySFStatic)tile).setAlterPos(alter);
            ((TileEntitySFStatic)tile).setID(sfbId);
        }
        if (doStrike && world instanceof ServerWorld) {
            StormForgeHelper.spawnLighting((ServerWorld)world, pos, false);
        }
    }

    private void removeStormForgeBlock(World world, BlockPos pos, byte sfbId) {
        if (sfbId == -1) {
            return;
        }
        BlockState sfsb = BLOCK_ARRAY[sfbId].getSourceBlock();
        Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)sfsb, (boolean)false);
    }

    public static boolean repairStormForge(World world, BlockPos pos) {
        BlockPos alter;
        BlockState state;
        if (world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        if ((state = world.func_180495_p(pos)).func_177230_c() != Values.blockStormForge) {
            return false;
        }
        if (state.func_177229_b(BlockStormForge.PART) == BlockStormForge.StormForgeBlock.ALTER) {
            INSTANCE.sfScanner(world, pos, EnumMode.BUILD, false);
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntitySFStatic && (alter = ((TileEntitySFStatic)tile).getAlterPos()) != null) {
            INSTANCE.sfScanner(world, alter, EnumMode.BUILD, false);
            return true;
        }
        return false;
    }

    private static SFBlock[] populateArray() {
        SFBlock[] array = new SFBlock[]{new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Blocks.field_150371_ca, BlockStormForge.StormForgeBlock.MONOLITH_SMOOTH, null), new SFBlock(TAG_CARVED_QUARTZ, Blocks.field_196772_fk, BlockStormForge.StormForgeBlock.MONOLITH, Direction.NORTH), new SFBlock(TAG_CARVED_QUARTZ, Blocks.field_196772_fk, BlockStormForge.StormForgeBlock.MONOLITH, Direction.EAST), new SFBlock(TAG_CARVED_QUARTZ, Blocks.field_196772_fk, BlockStormForge.StormForgeBlock.MONOLITH, Direction.SOUTH), new SFBlock(TAG_CARVED_QUARTZ, Blocks.field_196772_fk, BlockStormForge.StormForgeBlock.MONOLITH, Direction.WEST), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Blocks.field_150371_ca, BlockStormForge.StormForgeBlock.MONOLITH_LOWPEAK, Direction.NORTH), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Blocks.field_150371_ca, BlockStormForge.StormForgeBlock.MONOLITH_LOWPEAK, Direction.EAST), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Blocks.field_150371_ca, BlockStormForge.StormForgeBlock.MONOLITH_LOWPEAK, Direction.SOUTH), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Blocks.field_150371_ca, BlockStormForge.StormForgeBlock.MONOLITH_LOWPEAK, Direction.WEST), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Blocks.field_150371_ca, BlockStormForge.StormForgeBlock.MONOLITH_HIGHPEAK, Direction.NORTH), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Blocks.field_150371_ca, BlockStormForge.StormForgeBlock.MONOLITH_HIGHPEAK, Direction.EAST), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Blocks.field_150371_ca, BlockStormForge.StormForgeBlock.MONOLITH_HIGHPEAK, Direction.SOUTH), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Blocks.field_150371_ca, BlockStormForge.StormForgeBlock.MONOLITH_HIGHPEAK, Direction.WEST), new SFBlock(TAG_ENDIMIUM, Values.blockEndimium, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_CORNER, Direction.NORTH), new SFBlock(TAG_ENDIMIUM, Values.blockEndimium, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_CORNER, Direction.EAST), new SFBlock(TAG_ENDIMIUM, Values.blockEndimium, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_CORNER, Direction.SOUTH), new SFBlock(TAG_ENDIMIUM, Values.blockEndimium, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_CORNER, Direction.WEST), new SFBlock(TAG_ENDIMIUM, Values.blockEndimium, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_EDGE, Direction.NORTH), new SFBlock(TAG_ENDIMIUM, Values.blockEndimium, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_EDGE, Direction.EAST), new SFBlock(TAG_ENDIMIUM, Values.blockEndimium, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_EDGE, Direction.SOUTH), new SFBlock(TAG_ENDIMIUM, Values.blockEndimium, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_EDGE, Direction.WEST), new SFBlock(TAG_ENDIMIUM, Values.blockEndimium, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_AQUADUCT, Direction.NORTH), new SFBlock(TAG_ENDIMIUM, Values.blockEndimium, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_AQUADUCT, Direction.EAST), new SFBlock(TAG_ENDIMIUM, Values.blockEndimium, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_AQUADUCT, Direction.SOUTH), new SFBlock(TAG_ENDIMIUM, Values.blockEndimium, BlockStormForge.StormForgeBlock.PLATFORM_MONOLITH_AQUADUCT, Direction.WEST), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Blocks.field_150451_bX, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, Direction.NORTH), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Blocks.field_150451_bX, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, Direction.EAST), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Blocks.field_150451_bX, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, Direction.SOUTH), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Blocks.field_150451_bX, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, Direction.WEST), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_LAPIS, Blocks.field_150368_y, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT_TEE, Direction.NORTH), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_LAPIS, Blocks.field_150368_y, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT_TEE, Direction.EAST), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_LAPIS, Blocks.field_150368_y, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT_TEE, Direction.SOUTH), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_LAPIS, Blocks.field_150368_y, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT_TEE, Direction.WEST), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_IRON, Blocks.field_150339_S, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, Direction.NORTH), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_IRON, Blocks.field_150339_S, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, Direction.EAST), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_IRON, Blocks.field_150339_S, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, Direction.SOUTH), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_IRON, Blocks.field_150339_S, BlockStormForge.StormForgeBlock.PLATFORM_AQUADUCT, Direction.WEST), new SFBlock(TAG_BURNIUM, Values.blockBurnium, BlockStormForge.StormForgeBlock.PLATFORM_EDGE, Direction.NORTH), new SFBlock(TAG_BURNIUM, Values.blockBurnium, BlockStormForge.StormForgeBlock.PLATFORM_EDGE, Direction.EAST), new SFBlock(TAG_BURNIUM, Values.blockBurnium, BlockStormForge.StormForgeBlock.PLATFORM_EDGE, Direction.SOUTH), new SFBlock(TAG_BURNIUM, Values.blockBurnium, BlockStormForge.StormForgeBlock.PLATFORM_EDGE, Direction.WEST), new SFBlock((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_GOLD, Blocks.field_150340_R, BlockStormForge.StormForgeBlock.PLATFORM_RUNE, null), new SFBlock(TAG_ALTER_BASE, Values.blockEndimium, true, BlockStormForge.StormForgeBlock.PLATFORM_ALTER_AQUADUCT, null)};
        return array;
    }

    public static class SFBlock {
        private final Block sourceBlock;
        private final BlockState forgeBlock;
        private final Direction blockFacing;
        private final ITag.INamedTag<Block> tag;

        SFBlock(ITag.INamedTag<Block> tag, Block sourceBlock, BlockStormForge.StormForgeBlock placeType, Direction facing) {
            this(tag, sourceBlock, false, placeType, facing);
        }

        SFBlock(ITag.INamedTag<Block> tag, Block sourceBlock, boolean randomize, BlockStormForge.StormForgeBlock placeType, Direction facing) {
            List blocks;
            this.tag = tag;
            this.sourceBlock = randomize ? ((blocks = tag.func_230236_b_()).isEmpty() ? sourceBlock : (Block)blocks.iterator().next()) : sourceBlock;
            this.forgeBlock = (BlockState)Values.blockStormForge.func_176223_P().func_206870_a(BlockStormForge.PART, (Comparable)((Object)placeType));
            this.blockFacing = facing;
        }

        public ItemStack getSourceStack() {
            return new ItemStack((IItemProvider)this.sourceBlock);
        }

        public BlockState getSourceBlock() {
            return this.sourceBlock.func_176223_P();
        }

        public BlockState getForgeBlock() {
            return this.geBlockWithRotation(this.forgeBlock, null);
        }

        public BlockState getForgeBlockWithRotation(Direction facing) {
            return this.geBlockWithRotation(this.forgeBlock, facing);
        }

        private BlockState geBlockWithRotation(BlockState state, Direction rotation) {
            if (rotation == null) {
                rotation = this.getFacing();
            }
            return (BlockState)state.func_206870_a((Property)BlockStormForge.FACING, (Comparable)rotation);
        }

        public Direction getFacing() {
            return this.blockFacing != null ? this.blockFacing : Direction.Plane.HORIZONTAL.func_179518_a(Function.random);
        }

        public boolean isCorrectBlock(Block block) {
            return this.tag.func_230235_a_((Object)block) || block == this.sourceBlock;
        }
    }

    private static enum EnumMode {
        SCAN,
        SCAN_BUILD,
        BUILD,
        REMOVE;

    }
}

