/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.network.PacketBase;
import shetiphian.terraqueous.client.fx.FXBolt;

public class PacketBolt
extends PacketBase {
    private final Vector3d vStart;
    private final Vector3d vEnd;
    private final int color;

    public PacketBolt(Vector3d from, Vector3d to, int color) {
        this.vStart = from;
        this.vEnd = to;
        this.color = color;
    }

    public static void writeData(PacketBolt packet, PacketBuffer buffer) {
        buffer.writeDouble(packet.vStart.field_72450_a);
        buffer.writeDouble(packet.vStart.field_72448_b);
        buffer.writeDouble(packet.vStart.field_72449_c);
        buffer.writeDouble(packet.vEnd.field_72450_a);
        buffer.writeDouble(packet.vEnd.field_72448_b);
        buffer.writeDouble(packet.vEnd.field_72449_c);
        buffer.writeInt(packet.color);
    }

    public static PacketBolt readData(PacketBuffer buffer) {
        Vector3d vStart = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        Vector3d vEnd = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        return new PacketBolt(vStart, vEnd, buffer.readInt());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClientSide(PlayerEntity player) {
        FXBolt bolt = new FXBolt((ClientWorld)player.func_130014_f_(), this.vStart, this.vEnd, this.color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)bolt);
    }

    public void handleServerSide(PlayerEntity player) {
    }
}

