/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.inventory.ContainerCraftBench;
import shetiphian.terraqueous.common.inventory.InventoryCraftBench;
import shetiphian.terraqueous.common.tileentity.TileEntityCrafting;

public class TileEntityCraftBench
extends TileEntityCrafting {
    private FakePlayer fakePlayer;
    public GhostMatrix ghostMatrix = new GhostMatrix((TileEntity)this);
    public boolean isCloud;
    private static final List<ICraftingRecipe> EMPTY_LIST = Collections.emptyList();
    private List<ICraftingRecipe> recipes = EMPTY_LIST;
    private int recipeIndex = 0;

    public TileEntityCraftBench(boolean isCloud) {
        super(isCloud ? Values.tileCloudCraftBench : Values.tileCraftBench);
        this.isCloud = isCloud;
        this.inventory = new InventoryCraftBench(this);
        InventoryCraftBench inv = (InventoryCraftBench)this.inventory;
        this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapperBasic(), inv.getWrapperOutput(), inv.getWrapperStorage()});
        this.sidedWrapper.setFaceIndex(Direction.DOWN, 1);
        this.sidedWrapper.setFaceIndex(Direction.UP, 2);
        this.sidedWrapper.setFaceIndex(Direction.NORTH, 0);
        this.sidedWrapper.setFaceIndex(Direction.SOUTH, 0);
        this.sidedWrapper.setFaceIndex(Direction.WEST, 2);
        this.sidedWrapper.setFaceIndex(Direction.EAST, 1);
    }

    @Override
    protected void buildNBT(CompoundNBT nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74757_a("isCloud", this.isCloud);
        this.ghostMatrix.writeToNBT(nbtTag);
        nbtTag.func_74768_a("index", this.recipeIndex);
    }

    @Override
    protected void processNBT(CompoundNBT nbtTag) {
        super.processNBT(nbtTag);
        this.isCloud = nbtTag.func_74767_n("isCloud");
        this.ghostMatrix.readFromNBT(nbtTag);
        this.recipeIndex = nbtTag.func_74762_e("index");
    }

    @Override
    protected void processNBT_SaveOnly(CompoundNBT nbtTag) {
        if (nbtTag.func_74764_b("itemOutput") || nbtTag.func_74764_b("itemsChest") || nbtTag.func_74764_b("itemsBuffer")) {
            ItemStack itemOutput = this.itemReader(nbtTag, "itemOutput");
            ItemStack[] itemsChest = this.listReader(nbtTag.func_150295_c("itemsChest", 10), 27);
            ItemStack[] itemsBuffer = this.listReader(nbtTag.func_150295_c("itemsBuffer", 10), 2);
            ItemStack[] contents = new ItemStack[30];
            contents[0] = itemOutput;
            System.arraycopy(itemsChest, 0, contents, 1, 27);
            System.arraycopy(itemsBuffer, 0, contents, 28, 2);
            ((InventoryCraftBench)this.inventory).setContents(contents);
        } else {
            super.processNBT_SaveOnly(nbtTag);
        }
    }

    public void setCraftResult(ItemStack stack) {
        this.inventory.func_70299_a(0, stack);
    }

    public boolean ghostCraftCanTakeStack() {
        return this.canCraft();
    }

    public void ghostCraftOnPickupFromSlot(PlayerEntity player, ItemStack stack) {
        this.doCraft(player, stack);
    }

    public boolean canCraft() {
        return this.getSourceSlots() != null;
    }

    @Nonnull
    public ItemStack doCraft(PlayerEntity player, ItemStack stack) {
        int index;
        if (this.field_145850_b.field_72995_K) {
            return stack;
        }
        byte[] sourceSlots = this.getSourceSlots();
        if (sourceSlots == null) {
            return ItemStack.field_190927_a;
        }
        GhostMatrix craftMatrix = new GhostMatrix((TileEntity)this);
        for (int index2 = 0; index2 < 9; index2 = (int)((byte)(index2 + 1))) {
            if (sourceSlots[index2] > -1) {
                ItemStack sourceStack = this.inventory.func_70301_a((int)sourceSlots[index2]);
                craftMatrix.copyStackTo(index2, !sourceStack.func_190926_b() ? sourceStack.func_77946_l().func_77979_a(1) : ItemStack.field_190927_a);
                continue;
            }
            craftMatrix.copyStackTo(index2, ItemStack.field_190927_a);
        }
        ContainerCraftBench.GhostMatrixCrafting ghostCrafting = new ContainerCraftBench.GhostMatrixCrafting((IInventory)craftMatrix);
        ICraftingRecipe recipe = this.getRecipe(ghostCrafting, this.recipeIndex);
        ItemStack tempStack = stack;
        if (recipe != null) {
            tempStack = recipe.func_77572_b((IInventory)ghostCrafting);
        }
        if (recipe == null || tempStack.func_190926_b()) {
            if (player != null && Function.areItemStacksEqual((ItemStack)player.field_71071_by.func_70445_o(), (ItemStack)stack)) {
                if (player.field_71071_by.func_70445_o().func_190916_E() > stack.func_190916_E()) {
                    player.field_71071_by.func_70445_o().func_190920_e(player.field_71071_by.func_70445_o().func_190916_E() - stack.func_190916_E());
                } else {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
            }
            return ItemStack.field_190927_a;
        }
        tempStack.func_190920_e(stack.func_190916_E());
        stack = tempStack;
        if (player == null) {
            if (this.fakePlayer == null && this.func_145831_w() instanceof ServerWorld) {
                this.fakePlayer = new FakePlayer((ServerWorld)this.func_145831_w(), new GameProfile(null, "TerraqueousCraftBench"));
            }
            player = this.fakePlayer;
        } else {
            player.field_71071_by.func_70437_b(stack);
        }
        if (player != null) {
            BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)stack, (IInventory)craftMatrix);
            new ContainerCraftBench.SlotGhostCrafting(player, ghostCrafting).onPlayerCrafting(stack);
            ForgeHooks.setCraftingPlayer((PlayerEntity)player);
        }
        NonNullList remainingItems = recipe.func_179532_b((IInventory)ghostCrafting);
        ForgeHooks.setCraftingPlayer(null);
        for (index = 0; index < remainingItems.size(); ++index) {
            ItemStack craftStack = craftMatrix.func_70301_a(index);
            ItemStack remainStack = (ItemStack)remainingItems.get(index);
            if (!craftStack.func_190926_b()) {
                craftMatrix.func_70298_a(index, 1);
                craftStack = craftMatrix.func_70301_a(index);
            }
            if (remainStack.func_190926_b()) continue;
            if (craftStack.func_190926_b()) {
                craftMatrix.func_70299_a(index, remainStack);
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)craftStack, (ItemStack)remainStack) && ItemStack.func_77970_a((ItemStack)craftStack, (ItemStack)remainStack)) {
                remainStack.func_190917_f(craftStack.func_190916_E());
                craftMatrix.func_70299_a(index, remainStack);
                continue;
            }
            if (player != null && player.field_71071_by.func_70441_a(remainStack)) continue;
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)remainStack);
        }
        for (index = 0; index < 9; index = (int)((byte)(index + 1))) {
            if (sourceSlots[index] <= -1) continue;
            this.inventory.func_70298_a((int)sourceSlots[index], 1);
            ItemStack unusedStack = craftMatrix.func_70301_a(index);
            if (unusedStack.func_190926_b()) continue;
            if (unusedStack.func_77973_b().func_77645_m()) {
                this.inventory.func_70299_a((int)sourceSlots[index], unusedStack);
                continue;
            }
            int outputSlot = -1;
            if (FluidUtil.getFluidHandler((ItemStack)unusedStack) != null && (outputSlot = (int)this.getOutputSlot(new ItemStack[]{this.inventory.func_70301_a(28), this.inventory.func_70301_a(29)}, unusedStack, false)) > -1) {
                ItemStack stackInSlot = this.inventory.func_70301_a(28 + outputSlot);
                if (!stackInSlot.func_190926_b()) {
                    stackInSlot.func_190917_f(unusedStack.func_190916_E());
                } else {
                    this.inventory.func_70299_a(28 + outputSlot, unusedStack);
                }
            }
            if (outputSlot != -1) continue;
            ItemStack[] itemsChest = new ItemStack[27];
            System.arraycopy(this.inventory.getContents(), 1, itemsChest, 0, 27);
            outputSlot = this.getOutputSlot(itemsChest, unusedStack, false);
            if (outputSlot > -1) {
                ItemStack stackInSlot = this.inventory.func_70301_a(1 + outputSlot);
                if (!stackInSlot.func_190926_b()) {
                    stackInSlot.func_190917_f(unusedStack.func_190916_E());
                    continue;
                }
                this.inventory.func_70299_a(1 + outputSlot, unusedStack);
                continue;
            }
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)unusedStack);
        }
        this.func_70296_d();
        return stack;
    }

    private byte[] getSourceSlots() {
        byte[] slots = new byte[9];
        ItemStack[] matrix = this.ghostMatrix.getContents();
        ItemStack[] chest = new ItemStack[this.inventory.getContents().length];
        for (int slotId = 0; slotId < chest.length; ++slotId) {
            ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
            chest[slotId] = !stackInSlot.func_190926_b() ? stackInSlot.func_77946_l() : ItemStack.field_190927_a;
        }
        ICraftingRecipe recipe = this.getRecipe(new ContainerCraftBench.GhostMatrixCrafting((IInventory)this.ghostMatrix), this.recipeIndex);
        if (recipe == null) {
            return null;
        }
        for (int matrixSlot = 0; matrixSlot < 9; matrixSlot = (int)((byte)(matrixSlot + 1))) {
            int chestSlot;
            ItemStack target = matrix[matrixSlot];
            if (target.func_190926_b()) {
                slots[matrixSlot] = -1;
                continue;
            }
            boolean foundItem = false;
            for (chestSlot = 1; chestSlot < 28; chestSlot = (int)((byte)(chestSlot + 1))) {
                if (chest[chestSlot].func_190926_b() || !Function.areItemStacksEqual((ItemStack)target, (ItemStack)chest[chestSlot])) continue;
                foundItem = true;
                break;
            }
            if (!foundItem) {
                block3: for (Ingredient ingredient : recipe.func_192400_c()) {
                    if (!ingredient.test(target)) continue;
                    for (chestSlot = 1; chestSlot < 28; chestSlot = (int)((byte)(chestSlot + 1))) {
                        if (chest[chestSlot].func_190926_b() || !ingredient.test(chest[chestSlot])) continue;
                        foundItem = true;
                        break block3;
                    }
                }
            }
            if (foundItem) {
                slots[matrixSlot] = chestSlot;
                chest[chestSlot].func_190918_g(1);
                if (!chest[chestSlot].func_190926_b()) continue;
                chest[chestSlot] = ItemStack.field_190927_a;
                continue;
            }
            return null;
        }
        return slots;
    }

    public ICraftingRecipe getRecipe(CraftingInventory inventory, int index) {
        if (this.recipes == null || this.recipes == EMPTY_LIST) {
            this.onCraftMatrixChanged(inventory);
        }
        if (!this.recipes.isEmpty() && index <= this.recipes.size()) {
            return this.recipes.get(index);
        }
        return null;
    }

    public void onCraftMatrixChanged(CraftingInventory inventory) {
        this.recipes.clear();
        this.recipeIndex = 0;
        if (this.field_145850_b != null) {
            this.recipes = this.field_145850_b.func_199532_z().func_215370_b(IRecipeType.field_222149_a, (IInventory)inventory, this.field_145850_b);
            if (this.recipes == null) {
                this.recipes = new ArrayList<ICraftingRecipe>();
            }
            return;
        }
        this.recipes = EMPTY_LIST;
    }

    private static class GhostMatrix
    extends InventoryInternal {
        GhostMatrix(TileEntity invOwner) {
            super(invOwner, "ghostmatrix", 9, 1, "CraftBench-CraftMatrix");
        }

        void copyStackTo(int slotId, ItemStack itemStack) {
            if (this.okSlotId(slotId) && !itemStack.func_190926_b()) {
                this.contents[slotId] = itemStack.func_77946_l();
                this.contents[slotId].func_190920_e(1);
            }
        }
    }
}

