/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.tileentity.TileEntityBase;

public abstract class TileEntityCrafting
extends TileEntityBase
implements ISidedWrapper {
    public InventoryInternal inventory;
    ISidedWrapper.SidedWrapper sidedWrapper;
    private final IInventory processSlot = new InventoryInternal((TileEntity)this, "furnace_process", 1, 1, "");

    protected TileEntityCrafting(TileEntityType<?> type) {
        super(type);
    }

    protected void buildNBT(CompoundNBT nbtTag) {
        this.sidedWrapper.writeToNBT(nbtTag);
    }

    protected void buildNBT_SaveOnly(CompoundNBT nbtTag) {
        this.inventory.writeToNBT(nbtTag, "items");
    }

    protected void processNBT(CompoundNBT nbtTag) {
        this.sidedWrapper.readFromNBT(nbtTag);
    }

    protected void processNBT_SaveOnly(CompoundNBT nbtTag) {
        this.inventory.readFromNBT(nbtTag, "items");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.sidedWrapper.getWrapper(Direction.SOUTH, facing)).cast();
        }
        return super.getCapability(capability, facing);
    }

    public ISidedWrapper.SidedWrapper getSidedWrapper() {
        return this.sidedWrapper;
    }

    protected Direction getFacing() {
        return Direction.SOUTH;
    }

    ItemStack itemReader(CompoundNBT nbtTag, String name) {
        INBT compound = nbtTag.func_74781_a(name);
        return compound instanceof CompoundNBT ? ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound)) : ItemStack.field_190927_a;
    }

    ItemStack[] listReader(ListNBT listStacks, int length) {
        Object[] stacks = new ItemStack[length];
        Arrays.fill(stacks, ItemStack.field_190927_a);
        for (int index = 0; index < listStacks.size(); index = (int)((byte)(index + 1))) {
            CompoundNBT entry = listStacks.func_150305_b(index);
            byte slot = entry.func_74771_c("slot");
            if (slot < 0 || slot >= length) continue;
            stacks[slot] = ItemStack.func_199557_a((CompoundNBT)entry);
        }
        return stacks;
    }

    public byte getOutputSlot(ItemStack[] itemsOutput, ItemStack item, boolean smelted) {
        if (smelted) {
            item = (ItemStack)this.getSmelted(item).getLeft();
        }
        if (!item.func_190926_b()) {
            boolean useFreeSlot = !item.func_77985_e();
            for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
                for (byte slot = 0; slot < itemsOutput.length; slot = (byte)(slot + 1)) {
                    if (!this.canPlaceInSlot(itemsOutput[slot], item, useFreeSlot)) continue;
                    return slot;
                }
                useFreeSlot = true;
            }
        }
        return -1;
    }

    boolean canPlaceInSlot(ItemStack output, ItemStack item, boolean useFreeSlot) {
        if (useFreeSlot) {
            return output.func_190926_b();
        }
        return !output.func_190926_b() && output.func_77969_a(item) && output.func_190916_E() + item.func_190916_E() <= item.func_77976_d();
    }

    public boolean isSmeltable(ItemStack input) {
        return !((ItemStack)this.getSmelted(input).getLeft()).func_190926_b();
    }

    @Nonnull
    public Triple<ItemStack, Float, Integer> getSmelted(ItemStack input) {
        if (this.field_145850_b != null && !input.func_190926_b()) {
            ItemStack result;
            this.processSlot.func_70299_a(0, input.func_77946_l());
            FurnaceRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222150_b, this.processSlot, this.field_145850_b).orElse(null);
            if (recipe != null && !(result = recipe.func_77572_b(this.processSlot)).func_190926_b()) {
                return Triple.of((Object)result, (Object)Float.valueOf(recipe.func_222138_b()), (Object)recipe.func_222137_e());
            }
        }
        return Triple.of((Object)ItemStack.field_190927_a, (Object)Float.valueOf(0.0f), (Object)0);
    }

    public void addExtraDrops(List<ItemStack> drops) {
        for (ItemStack stack : this.inventory.getContents()) {
            if (stack.func_190926_b()) continue;
            drops.add(stack);
        }
    }
}

