/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockFlowerPot;

public class TileEntityFlowerPot
extends TileEntityRGB16
implements IRGB16_Tile {
    private ItemStack plantStack = ItemStack.field_190927_a;
    private Direction plantFacing = Direction.SOUTH;
    private RenderStyle renderStyle = null;

    public TileEntityFlowerPot() {
        super(Values.tileFlowerPot, BlockFlowerPot.BASE_COLOR);
    }

    public void buildNBT(CompoundNBT nbtTag) {
        super.buildNBT(nbtTag);
        if (!this.plantStack.func_190926_b()) {
            nbtTag.func_218657_a("plant", (INBT)this.plantStack.func_77955_b(new CompoundNBT()));
            nbtTag.func_74778_a("facing", this.plantFacing.func_176610_l());
        }
    }

    public void processNBT(CompoundNBT nbtTag) {
        super.processNBT(nbtTag);
        if (nbtTag.func_74764_b("plant")) {
            this.plantStack = ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("plant"));
            this.plantFacing = Direction.func_176739_a((String)nbtTag.func_74779_i("facing"));
        } else {
            this.plantStack = ItemStack.field_190927_a;
        }
    }

    @Nonnull
    public ItemStack getPlantStack() {
        return this.plantStack;
    }

    public boolean setPlantStack(@Nonnull ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() instanceof BlockItem) {
            this.plantStack = stack;
            if (this.func_145831_w().field_72995_K) {
                this.setRenderStyle();
            }
            return true;
        }
        return false;
    }

    public Direction getPlantFacing() {
        return this.plantFacing;
    }

    public void setPlantFacing(Direction facing) {
        this.plantFacing = facing.func_176736_b() < 0 ? Direction.SOUTH : facing;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderStyle getRenderStyle() {
        if (this.renderStyle == null) {
            this.setRenderStyle();
        }
        return this.renderStyle;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setRenderStyle() {
        String name;
        if (this.plantStack == null) {
            this.renderStyle = RenderStyle.NONE;
            return;
        }
        ResourceLocation resourceName = this.plantStack.func_77973_b().getRegistryName();
        if (resourceName != null && Values.flowerpotOverrides.containsKey(name = resourceName.func_110624_b() + ":" + resourceName.func_110623_a())) {
            this.renderStyle = RenderStyle.getStyle(Values.flowerpotOverrides.get(name));
            return;
        }
        this.renderStyle = RenderStyle.DEFAULT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bounds = super.getRenderBoundingBox();
        if (!this.plantStack.func_190926_b()) {
            if (this.func_195044_w().func_177230_c() == Values.blockLargeFlowerPot) {
                return bounds.func_72321_a(0.5, 1.5, 0.5);
            }
            return bounds.func_72321_a(0.0, 1.0, 0.0);
        }
        return bounds;
    }

    public static enum RenderStyle {
        CROSS_SINGLE,
        CROSS_MULTI,
        BLOCK,
        PANE,
        TALL,
        DEFAULT,
        NONE;


        static RenderStyle getStyle(byte style) {
            return RenderStyle.values()[MathHelper.func_76125_a((int)style, (int)0, (int)RenderStyle.values().length)];
        }
    }
}

