/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import shetiphian.core.common.Function;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockFlowerPot;
import shetiphian.terraqueous.common.block.BlockPlanter;

public class TileEntityPlanter
extends TileEntityRGB16
implements IRGB16_Tile {
    private ItemStack soilBlock = ItemStack.field_190927_a;
    private FluidStack soilFluid = FluidStack.EMPTY;
    private BlockState soilState = null;

    public TileEntityPlanter() {
        super(Values.tilePlanter, BlockFlowerPot.BASE_COLOR);
    }

    protected void buildNBT_SaveOnly(CompoundNBT nbtTag) {
        super.buildNBT_SaveOnly(nbtTag);
        if (!this.soilBlock.func_190926_b()) {
            nbtTag.func_218657_a("soil_block", (INBT)this.soilBlock.func_77955_b(new CompoundNBT()));
        } else if (!this.soilFluid.isEmpty()) {
            nbtTag.func_218657_a("soil_fluid", (INBT)this.soilFluid.writeToNBT(new CompoundNBT()));
        }
    }

    protected void processNBT_SaveOnly(CompoundNBT nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (nbtTag.func_74764_b("soil_block")) {
            this.soilBlock = ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("soil_block"));
        } else if (nbtTag.func_74764_b("soil_fluid")) {
            this.soilFluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbtTag.func_74775_l("soil_fluid"));
        }
    }

    public ItemStack getPickBlock() {
        if (!this.soilBlock.func_190926_b()) {
            return this.soilBlock;
        }
        if (!this.soilFluid.isEmpty()) {
            return FluidUtil.getFilledBucket((FluidStack)this.soilFluid);
        }
        return ItemStack.field_190927_a;
    }

    public BlockState getSoilState() {
        if (this.soilState == null && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.soilBlock.func_190926_b()) {
                Item item = this.soilBlock.func_77973_b();
                if (item instanceof BlockItem) {
                    this.soilState = ((BlockItem)item).func_179223_d().func_196258_a((BlockItemUseContext)new UseContext(this.field_145850_b, null, this.soilBlock));
                } else {
                    Function.dropItem((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)this.soilBlock);
                    this.soilBlock = ItemStack.field_190927_a;
                    Function.setBlock((IWorld)this.field_145850_b, (BlockPos)this.field_174879_c, (BlockState)((BlockState)this.func_195044_w().func_206870_a(BlockPlanter.SOIL, (Comparable)((Object)BlockPlanter.SoilType.NONE))), (boolean)true);
                }
            }
            if (!this.soilFluid.isEmpty()) {
                this.soilState = this.soilFluid.getFluid().func_207188_f().func_206883_i();
            }
        }
        return this.soilState;
    }

    public void setSoilFluid(@Nonnull FluidStack stack) {
        this.soilState = null;
        this.soilFluid = stack;
    }

    @Nonnull
    public FluidStack getSoilFluid() {
        return this.soilFluid;
    }

    public void setSoilBlock(@Nonnull ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() instanceof BlockItem) {
            this.soilState = null;
            this.soilBlock = stack;
            this.setSoilFluid(FluidStack.EMPTY);
        }
    }

    @Nonnull
    public ItemStack getSoilBlock() {
        return this.soilBlock;
    }
}

