/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.machines.CapabilityStormForge;
import shetiphian.terraqueous.api.machines.IStormForgeRechargeHandler;
import shetiphian.terraqueous.api.machines.IStormForgeRepairHandler;
import shetiphian.terraqueous.api.machines.IStormForgeStackHandler;
import shetiphian.terraqueous.api.machines.StormForgeRegistry;
import shetiphian.terraqueous.common.inventory.InventoryStormForge;
import shetiphian.terraqueous.common.misc.StormForgeHelper;
import shetiphian.terraqueous.common.tileentity.TileEntityAutoCrafting;

public class TileEntitySFController
extends TileEntityAutoCrafting {
    public short delayTime;
    private boolean isWorking;
    public float renderRotation;

    public TileEntitySFController() {
        super(Values.tileStormForgeAlter);
        this.inventory = new InventoryStormForge((TileEntity)this);
        InventoryStormForge inv = (InventoryStormForge)this.inventory;
        this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapper()});
        this.sidedWrapper.setFaceIndex(Direction.NORTH, 0);
        this.sidedWrapper.setFaceIndex(Direction.SOUTH, 0);
        this.sidedWrapper.setFaceIndex(Direction.WEST, 0);
        this.sidedWrapper.setFaceIndex(Direction.EAST, 0);
    }

    @Override
    protected void buildNBT(CompoundNBT nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74777_a("delayTime", this.delayTime);
        nbtTag.func_74757_a("isWorking", this.isWorking);
    }

    @Override
    protected void processNBT(CompoundNBT nbtTag) {
        super.processNBT(nbtTag);
        this.delayTime = nbtTag.func_74765_d("delayTime");
        this.isWorking = nbtTag.func_74767_n("isWorking");
    }

    @Override
    protected void processNBT_SaveOnly(CompoundNBT nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (!nbtTag.func_74764_b("items") && nbtTag.func_74764_b("processing")) {
            this.inventory.func_70299_a(6, ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("processing")));
        }
    }

    protected void buildNBT_SyncOnly(CompoundNBT nbtTag) {
        super.buildNBT_SyncOnly(nbtTag);
        nbtTag.func_218657_a("processing", (INBT)this.inventory.func_70301_a(6).func_77955_b(new CompoundNBT()));
    }

    protected void processNBT_SyncOnly(CompoundNBT nbtTag) {
        super.processNBT_SyncOnly(nbtTag);
        if (nbtTag.func_74764_b("processing")) {
            this.inventory.func_70299_a(6, ItemStack.func_199557_a((CompoundNBT)nbtTag.func_74775_l("processing")));
        }
    }

    public void func_73660_a() {
        ItemStack processStack;
        Block block;
        int lightningChance;
        World world = this.func_145831_w();
        if (world == null || world.field_72995_K) {
            return;
        }
        BlockPos pos = this.func_174877_v();
        boolean canBlockSeeSky = world.func_175710_j(pos.func_177984_a());
        boolean wasStruck = false;
        boolean instantComplete = false;
        if (canBlockSeeSky && world.func_72911_I() && world.field_73012_v.nextInt(lightningChance = (int)(200.0f - world.func_72819_i(1.0f) * 100.0f)) == 0) {
            wasStruck = true;
            if (this.field_145850_b instanceof ServerWorld) {
                StormForgeHelper.spawnLighting((ServerWorld)world, pos, false);
            }
            if (world.field_73012_v.nextInt(lightningChance * 2) == 0) {
                instantComplete = true;
            }
            StormForgeHelper.moveFire(this.func_145831_w(), this.func_174877_v());
        }
        if ((block = world.func_180495_p(pos.func_177984_a()).func_177230_c()) == Blocks.field_150480_ab || block instanceof FireBlock) {
            world.func_217377_a(pos.func_177984_a(), false);
        }
        if ((processStack = this.inventory.func_70301_a(6)).func_190926_b()) {
            this.getNextItem(true);
        } else {
            boolean moveToOutput;
            boolean bl = moveToOutput = !this.isWorking;
            if (this.isWorking) {
                if (this.isSFStack(6)) {
                    this.delayTime = (short)(this.delayTime + 1);
                    IStormForgeStackHandler handler = this.getStackHandler(processStack);
                    if (handler != null) {
                        this.inventory.func_70299_a(6, handler.processStack(processStack, this.delayTime, wasStruck, world, pos));
                        moveToOutput = handler.isFinished(processStack, this.delayTime, wasStruck, world, pos);
                    } else {
                        moveToOutput = true;
                    }
                    if (moveToOutput) {
                        this.delayTime = 0;
                    }
                } else {
                    Triple<ItemStack, Float, Integer> smelting;
                    boolean processed = false;
                    for (IStormForgeRechargeHandler iStormForgeRechargeHandler : StormForgeRegistry.getRechargeHandlers()) {
                        if (!iStormForgeRechargeHandler.handleStack(processStack)) continue;
                        processed = true;
                        boolean used = iStormForgeRechargeHandler.charge(processStack, this.getPower(iStormForgeRechargeHandler.multiplier(), wasStruck, !canBlockSeeSky), instantComplete);
                        moveToOutput = !used || iStormForgeRechargeHandler.isFull(processStack);
                        break;
                    }
                    if (!canBlockSeeSky && world.field_73012_v.nextInt(10) < 4) {
                        return;
                    }
                    this.delayTime = (short)(this.delayTime + this.getValue(1, wasStruck, false));
                    if (!processed) {
                        for (IStormForgeRepairHandler iStormForgeRepairHandler : StormForgeRegistry.getRepairHandlers()) {
                            if (!iStormForgeRepairHandler.handleStack(processStack)) continue;
                            processed = true;
                            if (iStormForgeRepairHandler.isRepaired(processStack)) {
                                this.delayTime = 0;
                                moveToOutput = true;
                                break;
                            }
                            if (this.delayTime < (Integer)Configuration.STORMFORGE.ticksPerRepairPoint.get() && !instantComplete) break;
                            this.delayTime = 0;
                            iStormForgeRepairHandler.repair(processStack, instantComplete);
                            if (wasStruck && !instantComplete) {
                                iStormForgeRepairHandler.repair(processStack, false);
                            }
                            moveToOutput = iStormForgeRepairHandler.isRepaired(processStack);
                            break;
                        }
                    }
                    if (!processed && !((ItemStack)(smelting = this.getSmelted(this.inventory.func_70301_a(6))).getLeft()).func_190926_b()) {
                        processed = true;
                        if (this.delayTime >= (int)((double)((Integer)smelting.getRight()).intValue() * (Double)Configuration.STORMFORGE.smeltTimeMultiplier.get()) || instantComplete) {
                            this.delayTime = 0;
                            ItemStack itemStack = (ItemStack)smelting.getLeft();
                            if (!itemStack.func_190926_b()) {
                                this.addExperience(((Float)smelting.getMiddle()).floatValue());
                                this.inventory.func_70299_a(6, itemStack.func_77946_l());
                            }
                        }
                    }
                    if (!processed) {
                        moveToOutput = true;
                    }
                }
            }
            if (moveToOutput) {
                this.isWorking = false;
                processStack = this.inventory.func_70301_a(6);
                byte outputSlot = this.getOutputSlot(processStack, true);
                if (outputSlot > -1) {
                    ItemStack outputSlotStack = this.inventory.func_70301_a((int)outputSlot);
                    if (!outputSlotStack.func_190926_b()) {
                        outputSlotStack.func_190917_f(!processStack.func_190926_b() ? processStack.func_190916_E() : 1);
                    } else {
                        this.inventory.func_70299_a((int)outputSlot, processStack);
                    }
                    this.inventory.func_70299_a(6, ItemStack.field_190927_a);
                    this.getNextItem(false);
                    Function.syncTile((TileEntity)this);
                }
            }
        }
    }

    private void getNextItem(boolean syncOnMove) {
        for (int slot = 0; slot < 6; slot = (int)((byte)(slot + 1))) {
            ItemStack stackInSlot = this.inventory.func_70301_a(slot);
            if (stackInSlot.func_190926_b() || this.getOutputSlot(stackInSlot, false) <= -1) continue;
            this.inventory.func_70299_a(6, stackInSlot.func_77979_a(1));
            this.isWorking = true;
            if (stackInSlot.func_190926_b()) {
                this.inventory.func_70299_a(slot, ItemStack.field_190927_a);
            }
            this.delayTime = 0;
            if (syncOnMove) {
                Function.syncTile((TileEntity)this);
            }
            return;
        }
    }

    private double getPower(double multiplier, boolean wasStruck, boolean doReduction) {
        int base = this.getValue((Integer)Configuration.STORMFORGE.powerPerTickBase.get(), wasStruck, doReduction);
        return (double)base * multiplier;
    }

    private int getValue(int base, boolean wasStruck, boolean doReduction) {
        float value = (float)base + (0.5f * (float)base * this.func_145831_w().func_72867_j(1.0f) + 0.75f * (float)base * this.func_145831_w().func_72819_i(1.0f) * 3.0f);
        return MathHelper.func_76123_f((float)(value *= (wasStruck ? 2.0f : 1.0f) * (doReduction ? 0.25f : 1.0f)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 3), (double)(this.func_174877_v().func_177956_o() - 1), (double)(this.func_174877_v().func_177952_p() - 3), (double)(this.func_174877_v().func_177958_n() + 4), (double)(this.func_174877_v().func_177956_o() + 4), (double)(this.func_174877_v().func_177952_p() + 4));
    }

    private byte getOutputSlot(ItemStack item, boolean currentItem) {
        Triple<ItemStack, Float, Integer> smelting;
        if (item == null) {
            return -1;
        }
        if (!currentItem && !((ItemStack)(smelting = this.getSmelted(this.inventory.func_70301_a(6))).getLeft()).func_190926_b()) {
            item = ((ItemStack)smelting.getLeft()).func_77946_l();
        }
        boolean useFreeSlot = !item.func_77985_e();
        for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
            for (byte slot = 7; slot < 13; slot = (byte)(slot + 1)) {
                int result;
                ItemStack stackInSlot;
                if (!(useFreeSlot ? this.inventory.func_70301_a((int)slot).func_190926_b() : !(stackInSlot = this.inventory.func_70301_a((int)slot)).func_190926_b() && stackInSlot.func_77969_a(item) && (result = stackInSlot.func_190916_E() + item.func_190916_E()) <= this.inventory.func_70297_j_() && result <= item.func_77976_d())) continue;
                return slot;
            }
            useFreeSlot = true;
        }
        return -1;
    }

    private IStormForgeStackHandler getStackHandler(ItemStack stack) {
        IStormForgeStackHandler handler = null;
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof IStormForgeStackHandler) {
                handler = (IStormForgeStackHandler)stack.func_77973_b();
            } else {
                LazyOptional capability = stack.getCapability(CapabilityStormForge.SPECIAL_STACK, null);
                if (capability.isPresent()) {
                    handler = (IStormForgeStackHandler)capability.orElse(null);
                }
            }
            if (handler == null) {
                for (IStormForgeStackHandler stackhandler : StormForgeRegistry.getStackHandlers()) {
                    if (!stackhandler.handleStack(stack)) continue;
                    return stackhandler;
                }
            }
        }
        return handler;
    }

    private boolean isSFStack(int slotId) {
        IStormForgeStackHandler handler;
        ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
        if (!stackInSlot.func_190926_b() && (handler = this.getStackHandler(stackInSlot)) != null) {
            return handler.handleStack(stackInSlot);
        }
        return false;
    }

    private boolean isChargeable(int slotId) {
        ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
        if (!stackInSlot.func_190926_b()) {
            for (IStormForgeRechargeHandler handler : StormForgeRegistry.getRechargeHandlers()) {
                if (!handler.handleStack(stackInSlot)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRepairable(int slotId) {
        ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
        if (!stackInSlot.func_190926_b()) {
            for (IStormForgeRepairHandler handler : StormForgeRegistry.getRepairHandlers()) {
                if (!handler.handleStack(stackInSlot)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCenterItem() {
        ItemStack stackInSlot = this.inventory.func_70301_a(6);
        return !stackInSlot.func_190926_b() && this.isWorking ? stackInSlot.func_77946_l() : ItemStack.field_190927_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public short getProcessType(byte slotId) {
        if (!this.inventory.func_70301_a((int)slotId).func_190926_b()) {
            if (slotId == 6 && !this.isWorking) {
                return -1;
            }
            if (this.isSFStack(slotId)) {
                return 4;
            }
            if (this.isChargeable(slotId)) {
                return 1;
            }
            if (this.isRepairable(slotId)) {
                return 2;
            }
            if (this.isSmeltable(this.inventory.func_70301_a((int)slotId))) {
                return 3;
            }
            return 0;
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressScaled(int graphicWidth) {
        int base = this.delayTime * graphicWidth;
        if (this.isSFStack(6)) {
            ItemStack stackInSlot = this.inventory.func_70301_a(6);
            IStormForgeStackHandler handler = this.getStackHandler(stackInSlot);
            int ticks = handler != null ? handler.ticksToComplete(stackInSlot) : -1;
            return ticks > 0 ? base / ticks : -1;
        }
        if (this.isChargeable(6)) {
            return -1;
        }
        if (this.isRepairable(6)) {
            return base / (Integer)Configuration.STORMFORGE.ticksPerRepairPoint.get();
        }
        Triple<ItemStack, Float, Integer> smelting = this.getSmelted(this.inventory.func_70301_a(6));
        if (!((ItemStack)smelting.getLeft()).func_190926_b()) {
            return (int)((double)base / ((double)((Integer)smelting.getRight()).intValue() * (Double)Configuration.STORMFORGE.smeltTimeMultiplier.get()));
        }
        return -1;
    }
}

