/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;
import shetiphian.terraqueous.common.worldgen.blockstateprovider.ProviderFlowers;

public class GenFlowers
extends WorldGenerator {
    private static final Configuration.Menu_Generator.SubMenu_Flowers config = Configuration.GENERATOR.FLOWERS;
    public static final BlockClusterFeatureConfig ALL_FLOWERS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new ProviderFlowers.Forest(), (BlockPlacer)new SimpleBlockPlacer()).func_227322_d_();
    public static final BlockClusterFeatureConfig FOREST_FLOWERS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new ProviderFlowers.Forest(), (BlockPlacer)new SimpleBlockPlacer()).func_227322_d_();
    public static final BlockClusterFeatureConfig PLAINS_FLOWERS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new ProviderFlowers.Plains(), (BlockPlacer)new SimpleBlockPlacer()).func_227322_d_();
    public static final BlockClusterFeatureConfig MOUNTAIN_FLOWERS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new ProviderFlowers.Mountain(), (BlockPlacer)new SimpleBlockPlacer()).func_227322_d_();
    public static final BlockClusterFeatureConfig WATER_FLOWERS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new ProviderFlowers.Water(), (BlockPlacer)new SimpleBlockPlacer()).func_227322_d_();
    public static final BlockClusterFeatureConfig JUNGLE_FLOWERS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new ProviderFlowers.Jungle(), (BlockPlacer)new SimpleBlockPlacer()).func_227322_d_();
    public static final BlockClusterFeatureConfig MAGIC_FLOWERS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new ProviderFlowers.Magic(), (BlockPlacer)new SimpleBlockPlacer()).func_227322_d_();

    static void addTo(Biome biome) {
        boolean biomeFlowers = (Boolean)GenFlowers.config.perBiomeFlowers.get();
        for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
            if (type == BiomeDictionary.Type.FOREST) {
                GenFlowers.addFeature(biome, biomeFlowers ? FOREST_FLOWERS_CONFIG : ALL_FLOWERS_CONFIG, (int)((Integer)GenFlowers.config.attempts_Forest.get()), (double)((Double)GenFlowers.config.chance_Forest.get()));
            }
            if (type == BiomeDictionary.Type.PLAINS) {
                GenFlowers.addFeature(biome, biomeFlowers ? PLAINS_FLOWERS_CONFIG : ALL_FLOWERS_CONFIG, (int)((Integer)GenFlowers.config.attempts_Plains.get()), (double)((Double)GenFlowers.config.chance_Plains.get()));
            }
            if (type == BiomeDictionary.Type.MOUNTAIN) {
                GenFlowers.addFeature(biome, biomeFlowers ? MOUNTAIN_FLOWERS_CONFIG : ALL_FLOWERS_CONFIG, (int)((Integer)GenFlowers.config.attempts_Mountain.get()), (double)((Double)GenFlowers.config.chance_Mountain.get()));
            }
            if (type == BiomeDictionary.Type.WATER) {
                GenFlowers.addFeature(biome, biomeFlowers ? WATER_FLOWERS_CONFIG : ALL_FLOWERS_CONFIG, (int)((Integer)GenFlowers.config.attempts_Water.get()), (double)((Double)GenFlowers.config.chance_Water.get()));
            }
            if (type == BiomeDictionary.Type.JUNGLE) {
                GenFlowers.addFeature(biome, biomeFlowers ? JUNGLE_FLOWERS_CONFIG : ALL_FLOWERS_CONFIG, (int)((Integer)GenFlowers.config.attempts_Jungle.get()), (double)((Double)GenFlowers.config.chance_Jungle.get()));
            }
            if (type != BiomeDictionary.Type.MAGICAL) continue;
            GenFlowers.addFeature(biome, biomeFlowers ? MAGIC_FLOWERS_CONFIG : ALL_FLOWERS_CONFIG, (int)((Integer)GenFlowers.config.attempts_Magical.get()), (double)((Double)GenFlowers.config.chance_Magical.get()));
        }
    }

    protected static void addFeature(Biome biome, BlockClusterFeatureConfig config, int count, double chance) {
        if (count > 0 && chance > 0.0) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)config).func_227228_a_(Placement.field_215033_s.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(count, (float)chance))));
        }
    }
}

