/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.common.worldgen.GenDoodads;
import shetiphian.terraqueous.common.worldgen.GenFlowers;
import shetiphian.terraqueous.common.worldgen.GenPlants;
import shetiphian.terraqueous.common.worldgen.GenTrees;
import shetiphian.terraqueous.common.worldgen.WorldGenRegistry;

public class WorldGenerator {
    public static void load() {
        Configuration.Menu_Generator config = Configuration.GENERATOR;
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (!BiomeDictionary.hasAnyType((Biome)biome)) continue;
            if (((Boolean)config.generateClouds.get()).booleanValue()) {
                WorldGenerator.addFeature(biome, (Feature<NoFeatureConfig>)((Feature)WorldGenRegistry.FEATURE_CLOUDS.get()), 1, 1.0);
            }
            if (((Boolean)config.generateDoodads.get()).booleanValue()) {
                GenDoodads.addTo(biome);
            }
            if (((Boolean)config.generateFlowers.get()).booleanValue()) {
                GenFlowers.addTo(biome);
            }
            if (((Boolean)config.generatePlants.get()).booleanValue()) {
                GenPlants.addTo(biome);
            }
            if (!((Boolean)config.generateTrees.get()).booleanValue()) continue;
            GenTrees.addTo(biome);
        }
    }

    public static boolean canGenerate(IWorld world, BlockPos pos, List<? extends String> blacklist) {
        return !WorldGenerator.isBlacklisted(world, blacklist) && pos.func_177956_o() > 0 && pos.func_177956_o() < WorldGenerator.getMaxWorldHeight(world);
    }

    public static int getMaxWorldHeight(IWorld world) {
        return world.func_230315_m_().func_241513_m_();
    }

    public static boolean isBlacklisted(IWorld world, List<? extends String> generatorList) {
        RegistryKey registryKey = world.func_201672_e().func_234922_V_();
        ResourceLocation registryName = registryKey.func_240901_a_();
        if (registryName != null) {
            String key = registryName.toString();
            for (String string : (List)Configuration.GENERATOR.DIM_BLACKLIST.global.get()) {
                if (!Pattern.compile(string).matcher(key).find()) continue;
                return true;
            }
            for (String string : generatorList) {
                if (!Pattern.compile(string).matcher(key).find()) continue;
                return true;
            }
        }
        return false;
    }

    public static DimensionType getDimension(IWorld world) {
        return world.func_230315_m_();
    }

    protected static boolean hasType(Biome biome, BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type type : types) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasAllTypes(Biome biome, BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type type : types) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type)) continue;
            return false;
        }
        return true;
    }

    protected static void addFeature(Biome biome, Feature<NoFeatureConfig> feature, int count, double chance) {
        if (count > 0 && chance > 0.0) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, feature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215033_s.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(count, (float)chance))));
        }
    }
}

