/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.blockstateprovider;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.terraqueous.common.worldgen.WorldGenRegistry;

public abstract class ProviderFlowers
extends BlockStateProvider {
    private final List<Block> FLOWERS = new ArrayList<Block>();

    protected ProviderFlowers(String ... ids) {
        for (String id : ids) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("terraqueous", id));
            if (block == null) continue;
            this.FLOWERS.add(block);
        }
    }

    public BlockState func_225574_a_(Random random, BlockPos pos) {
        if (this.FLOWERS.isEmpty()) {
            return Blocks.field_196605_bc.func_176223_P();
        }
        double d0 = MathHelper.func_151237_a((double)((1.0 + Biome.field_180281_af.func_215464_a((double)pos.func_177958_n() / 48.0, (double)pos.func_177952_p() / 48.0, false)) / 2.0), (double)0.0, (double)0.9999);
        return this.FLOWERS.get((int)(d0 * (double)this.FLOWERS.size())).func_176223_P();
    }

    public static class Magic
    extends ProviderFlowers {
        public static final Magic INSTANCE = new Magic();
        public static final Codec<Magic> CODEC = Codec.unit(() -> INSTANCE);

        public Magic() {
            super("trickster_bloom");
        }

        protected BlockStateProviderType<?> func_230377_a_() {
            return (BlockStateProviderType)WorldGenRegistry.PROVIDER_MAGIC_FLOWER.get();
        }
    }

    public static class Jungle
    extends ProviderFlowers {
        public static final Jungle INSTANCE = new Jungle();
        public static final Codec<Jungle> CODEC = Codec.unit(() -> INSTANCE);

        public Jungle() {
            super("fern", "lavender", "leichtlinii", "ghost_plant", "gray_ghost_plant", "primrose");
        }

        protected BlockStateProviderType<?> func_230377_a_() {
            return (BlockStateProviderType)WorldGenRegistry.PROVIDER_JUNGLE_FLOWER.get();
        }
    }

    public static class Water
    extends ProviderFlowers {
        public static final Water INSTANCE = new Water();
        public static final Codec<Water> CODEC = Codec.unit(() -> INSTANCE);

        public Water() {
            super("burdock", "leichtlinii", "deirdre", "blue_bell");
        }

        protected BlockStateProviderType<?> func_230377_a_() {
            return (BlockStateProviderType)WorldGenRegistry.PROVIDER_WATER_FLOWER.get();
        }
    }

    public static class Mountain
    extends ProviderFlowers {
        public static final Mountain INSTANCE = new Mountain();
        public static final Codec<Mountain> CODEC = Codec.unit(() -> INSTANCE);

        public Mountain() {
            super("burdock", "lavender", "rose");
        }

        protected BlockStateProviderType<?> func_230377_a_() {
            return (BlockStateProviderType)WorldGenRegistry.PROVIDER_MOUNTAIN_FLOWER.get();
        }
    }

    public static class Plains
    extends ProviderFlowers {
        public static final Plains INSTANCE = new Plains();
        public static final Codec<Plains> CODEC = Codec.unit(() -> INSTANCE);

        public Plains() {
            super("black_rose", "carnation", "lavender", "rose", "daffodil", "primrose", "marigold", "tulip");
        }

        protected BlockStateProviderType<?> func_230377_a_() {
            return (BlockStateProviderType)WorldGenRegistry.PROVIDER_PLAINS_FLOWER.get();
        }
    }

    public static class Forest
    extends ProviderFlowers {
        public static final Forest INSTANCE = new Forest();
        public static final Codec<Forest> CODEC = Codec.unit(() -> INSTANCE);

        public Forest() {
            super("fern", "trickster_bloom", "lavender", "leichtlinii", "ghost_plant", "gray_ghost_plant", "primrose");
        }

        protected BlockStateProviderType<?> func_230377_a_() {
            return (BlockStateProviderType)WorldGenRegistry.PROVIDER_FOREST_FLOWER.get();
        }
    }

    public static class All
    extends ProviderFlowers {
        public static final All INSTANCE = new All();
        public static final Codec<All> CODEC = Codec.unit(() -> INSTANCE);

        public All() {
            super("black_rose", "carnation", "fern", "burdock", "trickster_bloom", "lavender", "leichtlinii", "ghost_plant", "gray_ghost_plant", "rose", "deirdre", "daffodil", "blue_bell", "primrose", "marigold", "tulip");
        }

        protected BlockStateProviderType<?> func_230377_a_() {
            return (BlockStateProviderType)WorldGenRegistry.PROVIDER_ALL_FLOWER.get();
        }
    }
}

