/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.IPlantable;

public abstract class AbstractTreeFeature<T extends IFeatureConfig>
extends Feature<T> {
    protected IPlantable sapling = (IPlantable)Blocks.field_196674_t;
    protected final boolean doBlockNotify;

    public AbstractTreeFeature(Codec<T> codec, boolean doBlockNotify) {
        super(codec);
        this.doBlockNotify = doBlockNotify;
    }

    protected static boolean canBeReplacedByLogs(IWorldGenerationBaseReader world, BlockPos pos) {
        if (!(world instanceof IWorldReader)) {
            return world.func_217375_a(pos, state -> {
                Block block = state.func_177230_c();
                return state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E) || block == Blocks.field_196658_i || AbstractTreeFeature.func_227250_b_((Block)block) || block.func_203417_a((ITag)BlockTags.field_200031_h) || block.func_203417_a((ITag)BlockTags.field_200030_g) || block == Blocks.field_150395_bd;
            });
        }
        return world.func_217375_a(pos, state -> state.canBeReplacedByLogs((IWorldReader)world, pos));
    }

    protected static boolean isAirOrLeaves(IWorldGenerationBaseReader world, BlockPos pos) {
        if (!(world instanceof IWorldReader)) {
            return world.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
        }
        return world.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)world, pos));
    }

    protected static boolean isSoil(IWorldGenerationBaseReader world, BlockPos pos, IPlantable sapling) {
        if (!(world instanceof IBlockReader) || sapling == null) {
            return world.func_217375_a(pos, state -> {
                Block block = state.func_177230_c();
                return AbstractTreeFeature.func_227250_b_((Block)block) || block == Blocks.field_196658_i;
            });
        }
        return world.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)world, pos, Direction.UP, sapling));
    }

    protected void func_230367_a_(IWorldWriter world, BlockPos pos, BlockState state) {
        this.setStateWithCheck(world, pos, state);
    }

    protected final void setLogState(Set<BlockPos> changedBlocks, IWorldWriter world, BlockPos pos, BlockState state, MutableBoundingBox boundingBox) {
        this.setStateWithCheck(world, pos, state);
        boundingBox.func_78888_b(new MutableBoundingBox((Vector3i)pos, (Vector3i)pos));
        if (BlockTags.field_200031_h.func_230235_a_((Object)state.func_177230_c())) {
            changedBlocks.add(pos.func_185334_h());
        }
    }

    private void setStateWithCheck(IWorldWriter world, BlockPos pos, BlockState state) {
        if (this.doBlockNotify) {
            world.func_180501_a(pos, state, 19);
        } else {
            world.func_180501_a(pos, state, 18);
        }
    }

    public final boolean func_230362_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, BlockPos pos, T config) {
        HashSet set = Sets.newHashSet();
        MutableBoundingBox boundingBox = MutableBoundingBox.func_78887_a();
        boolean flag = this.place(set, world, rand, pos, boundingBox);
        if (boundingBox.field_78897_a > boundingBox.field_78893_d) {
            return false;
        }
        ArrayList list = Lists.newArrayList();
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BitSetVoxelShapePart part = new BitSetVoxelShapePart(boundingBox.func_78883_b(), boundingBox.func_78882_c(), boundingBox.func_78880_d());
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (flag && !set.isEmpty()) {
            for (BlockPos sPos : Lists.newArrayList((Iterable)set)) {
                if (boundingBox.func_175898_b((Vector3i)sPos)) {
                    part.func_199625_a(sPos.func_177958_n() - boundingBox.field_78897_a, sPos.func_177956_o() - boundingBox.field_78895_b, sPos.func_177952_p() - boundingBox.field_78896_c, true, true);
                }
                for (Direction direction : Direction.values()) {
                    BlockState blockstate;
                    mutable.func_189533_g((Vector3i)sPos).func_189536_c(direction);
                    if (set.contains(mutable) || !(blockstate = world.func_180495_p((BlockPos)mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                    ((Set)list.get(0)).add(mutable.func_185334_h());
                    this.setStateWithCheck((IWorldWriter)world, (BlockPos)mutable, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                    if (!boundingBox.func_175898_b((Vector3i)mutable)) continue;
                    part.func_199625_a(mutable.func_177958_n() - boundingBox.field_78897_a, mutable.func_177956_o() - boundingBox.field_78895_b, mutable.func_177952_p() - boundingBox.field_78896_c, true, true);
                }
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set1 = (Set)list.get(l - 1);
            Set set2 = (Set)list.get(l);
            for (BlockPos sPos : set1) {
                if (boundingBox.func_175898_b((Vector3i)sPos)) {
                    part.func_199625_a(sPos.func_177958_n() - boundingBox.field_78897_a, sPos.func_177956_o() - boundingBox.field_78895_b, sPos.func_177952_p() - boundingBox.field_78896_c, true, true);
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    mutable.func_189533_g((Vector3i)sPos).func_189536_c(direction1);
                    if (set1.contains(mutable) || set2.contains(mutable) || !(blockstate1 = world.func_180495_p((BlockPos)mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(l + 1));
                    this.setStateWithCheck((IWorldWriter)world, (BlockPos)mutable, blockstate2);
                    if (boundingBox.func_175898_b((Vector3i)mutable)) {
                        part.func_199625_a(mutable.func_177958_n() - boundingBox.field_78897_a, mutable.func_177956_o() - boundingBox.field_78895_b, mutable.func_177952_p() - boundingBox.field_78896_c, true, true);
                    }
                    set2.add(mutable.func_185334_h());
                }
            }
        }
        Template.func_222857_a((IWorld)world, (int)3, (VoxelShapePart)part, (int)boundingBox.field_78897_a, (int)boundingBox.field_78895_b, (int)boundingBox.field_78896_c);
        return flag;
    }

    protected abstract boolean place(Set<BlockPos> var1, ISeedReader var2, Random var3, BlockPos var4, MutableBoundingBox var5);

    protected IPlantable getSapling() {
        return this.sapling;
    }

    public void setSapling(IPlantable sapling) {
        this.sapling = sapling;
    }
}

