/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraftforge.common.Tags;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;
import shetiphian.terraqueous.common.worldgen.feature.FeatureTreeBase;

public class FeatureMiniTreeBase
extends FeatureTreeBase {
    private static final byte[] mapMiniTree = new byte[]{0, 0, 0, 0, 1, 0, 0, 0, 0, 6, 6, 6, 6, 4, 6, 6, 6, 6, 0, 6, 0, 6, 5, 6, 0, 6, 0};

    public FeatureMiniTreeBase(boolean doBlockNotifyOnPlace, PlantAPI.TreeType tree) {
        super(doBlockNotifyOnPlace, tree);
    }

    @Override
    protected int getTreeWidth() {
        return 3;
    }

    protected int getTreeHeight() {
        return 3;
    }

    @Override
    protected final int getFoliageHeight() {
        return 0;
    }

    @Override
    protected final int getTrunkHeight(Random random) {
        return 0;
    }

    @Override
    protected byte getMapValue(int index) {
        return mapMiniTree[index];
    }

    @Override
    protected boolean placeTree(Set<BlockPos> changedBlocks, ISeedReader world, Random random, BlockPos position, MutableBoundingBox boundingBox) {
        int index;
        int sZ;
        int chZ;
        int sX;
        int chX;
        int sY;
        int treeWidth = this.getTreeWidth();
        int treeHeight = this.getTreeHeight();
        if (position.func_177956_o() < 1 || position.func_177956_o() + 1 + treeHeight > WorldGenerator.getMaxWorldHeight((IWorld)world)) {
            return false;
        }
        boolean onStone = false;
        if (!FeatureMiniTreeBase.isSoil((IWorldGenerationBaseReader)world, position.func_177977_b(), this.getSapling())) {
            if (this.isStone((IWorldGenerationBaseReader)world, position.func_177977_b())) {
                onStone = true;
            } else {
                return false;
            }
        }
        BlockPos.Mutable mPos = new BlockPos.Mutable();
        mPos.func_189533_g((Vector3i)position);
        int chY = position.func_177956_o();
        for (sY = 0; sY < treeHeight; sY = (int)((byte)(sY + 1))) {
            chX = position.func_177958_n() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                chZ = position.func_177952_p() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    index = sY * treeWidth * treeWidth + sX + sZ * treeWidth;
                    if (this.getMapValue(index) > 0) {
                        mPos.func_181079_c(chX, chY, chZ);
                        if (!FeatureMiniTreeBase.canBeReplacedByLogs((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                            return false;
                        }
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        if (onStone) {
            mPos.func_189533_g((Vector3i)position.func_177977_b());
            this.func_230367_a_((IWorldWriter)world, (BlockPos)mPos, Blocks.field_150351_n.func_176223_P());
            this.toGravel((IWorldGenerationReader)world, mPos.func_177977_b(), random);
            this.toGravel((IWorldGenerationReader)world, mPos.func_177978_c(), random);
            this.toGravel((IWorldGenerationReader)world, mPos.func_177968_d(), random);
            this.toGravel((IWorldGenerationReader)world, mPos.func_177974_f(), random);
            this.toGravel((IWorldGenerationReader)world, mPos.func_177976_e(), random);
        }
        mPos.func_189533_g((Vector3i)position);
        chY = position.func_177956_o();
        for (sY = 0; sY < treeHeight; sY = (int)((byte)(sY + 1))) {
            chX = position.func_177958_n() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                chZ = position.func_177952_p() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    mPos.func_181079_c(chX, chY, chZ);
                    index = sY * treeWidth * treeWidth + sX + sZ * treeWidth;
                    byte mapValue = this.getMapValue(index);
                    if (mapValue > 0 && FeatureMiniTreeBase.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                        this.setState(changedBlocks, (IWorldWriter)world, (BlockPos)mPos, this.getBlockState(mapValue, random), boundingBox);
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        this.postPlacement(changedBlocks, (IWorldGenerationReader)world, random, position, boundingBox, 0);
        return true;
    }

    private boolean isStone(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> Tags.Blocks.STONE.func_230235_a_((Object)state.func_177230_c()));
    }

    private void toGravel(IWorldGenerationReader world, BlockPos pos, Random random) {
        if (random.nextBoolean() && this.isStone((IWorldGenerationBaseReader)world, pos)) {
            this.func_230367_a_((IWorldWriter)world, pos, Blocks.field_150351_n.func_176223_P());
        }
    }
}

