/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.inventory;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.config.Config;
import net.eidee.minecraft.terrible_chest.util.IntUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TerribleChestInventory
implements IInventory,
INBTSerializable<NBTTagCompound> {
    private int maxPage = 1;
    private Int2ObjectMap<Item> items = new Int2ObjectOpenHashMap();

    private boolean isValidIndex(int index) {
        return index >= 0 && index < this.func_70302_i_();
    }

    public int getMaxPage() {
        return Math.min(this.maxPage, Config.maxPageLimit);
    }

    public void setMaxPage(int maxPage) {
        this.maxPage = maxPage;
    }

    public int getItemCount(int index) {
        if (this.isValidIndex(index)) {
            return ((Item)this.items.getOrDefault((Object)index, (Object)Item.EMPTY)).getCount();
        }
        return 0;
    }

    public void setItemCount(int index, int count) {
        Item item;
        if (this.isValidIndex(index) && (item = (Item)this.items.getOrDefault((Object)index, (Object)Item.EMPTY)).isNotEmpty()) {
            item.setCount(count);
        }
    }

    public void swap(int index1, int index2) {
        Item item1 = (Item)this.items.remove(index1);
        Item item2 = (Item)this.items.remove(index2);
        if (item2 != null && item2.isNotEmpty()) {
            this.items.put(index1, (Object)item2);
        }
        if (item1 != null && item1.isNotEmpty()) {
            this.items.put(index2, (Object)item1);
        }
    }

    public IInventory createInventory() {
        return new IInventory(){

            public int func_70302_i_() {
                return TerribleChestInventory.this.func_70302_i_();
            }

            public boolean func_191420_l() {
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    if (!((Item)TerribleChestInventory.this.items.getOrDefault((Object)i, (Object)Item.EMPTY)).isNotEmpty()) continue;
                    return false;
                }
                return true;
            }

            public ItemStack func_70301_a(int index) {
                Item item = (Item)TerribleChestInventory.this.items.getOrDefault((Object)index, (Object)Item.EMPTY);
                if (item.isNotEmpty()) {
                    int itemCount = item.getCount();
                    int size = IntUtil.minUnsigned(this.func_70297_j_(), itemCount);
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)item.getStack(), (int)size);
                }
                return ItemStack.field_190927_a;
            }

            public ItemStack func_70298_a(int index, int count) {
                Item item;
                if (count > 0 && TerribleChestInventory.this.isValidIndex(index) && (item = (Item)TerribleChestInventory.this.items.getOrDefault((Object)index, (Object)Item.EMPTY)).isNotEmpty()) {
                    ItemStack stack = item.getStack();
                    int itemCount = item.getCount();
                    int _count = IntUtil.minUnsigned(count, itemCount);
                    if (_count == itemCount) {
                        TerribleChestInventory.this.items.remove(index);
                    }
                    item.setCount(itemCount - _count);
                    this.func_70296_d();
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)_count);
                }
                return ItemStack.field_190927_a;
            }

            public ItemStack func_70304_b(int index) {
                Item item;
                if (TerribleChestInventory.this.isValidIndex(index) && (item = (Item)TerribleChestInventory.this.items.remove(index)) != null) {
                    ItemStack stack = item.getStack();
                    int size = IntUtil.minUnsigned(stack.func_77976_d(), item.getCount());
                    this.func_70296_d();
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                }
                return ItemStack.field_190927_a;
            }

            public void func_70299_a(int index, ItemStack stack) {
                if (TerribleChestInventory.this.isValidIndex(index)) {
                    if (stack.func_190926_b()) {
                        Item item = (Item)TerribleChestInventory.this.items.remove(index);
                        if (item != null) {
                            this.func_70296_d();
                        }
                    } else {
                        Item item = new Item(stack);
                        TerribleChestInventory.this.items.put(index, (Object)item);
                        this.func_70296_d();
                    }
                }
            }

            public int func_70297_j_() {
                return TerribleChestInventory.this.func_70297_j_();
            }

            public void func_70296_d() {
            }

            public boolean func_70300_a(EntityPlayer player) {
                return true;
            }

            public void func_174889_b(EntityPlayer player) {
            }

            public void func_174886_c(EntityPlayer player) {
            }

            public boolean func_94041_b(int index, ItemStack stack) {
                return true;
            }

            public int func_174887_a_(int id) {
                return 0;
            }

            public void func_174885_b(int id, int value) {
            }

            public int func_174890_g() {
                return 0;
            }

            public void func_174888_l() {
                TerribleChestInventory.this.func_174888_l();
            }

            public String func_70005_c_() {
                return TerribleChestInventory.this.func_70005_c_();
            }

            public boolean func_145818_k_() {
                return TerribleChestInventory.this.func_145818_k_();
            }

            public ITextComponent func_145748_c_() {
                return TerribleChestInventory.this.func_145748_c_();
            }
        };
    }

    public int func_70302_i_() {
        return this.getMaxPage() * 27;
    }

    public boolean func_191420_l() {
        return this.items.isEmpty();
    }

    public ItemStack func_70301_a(int index) {
        return this.isValidIndex(index) ? ((Item)this.items.getOrDefault((Object)index, (Object)Item.EMPTY)).getStack() : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        Item item;
        if (this.isValidIndex(index) && (item = (Item)this.items.getOrDefault((Object)index, (Object)Item.EMPTY)).isNotEmpty()) {
            int itemCount = item.getCount();
            int _count = IntUtil.minUnsigned(count, itemCount);
            if (_count == itemCount) {
                this.items.remove(index);
                this.func_70296_d();
            }
            item.setCount(itemCount - _count);
            return ItemHandlerHelper.copyStackWithSize((ItemStack)item.stack, (int)_count);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        Item item;
        if (this.isValidIndex(index) && (item = (Item)this.items.remove(index)) != null) {
            this.func_70296_d();
            return item.getStack();
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.isValidIndex(index)) {
            if (stack.func_190926_b()) {
                Item item = (Item)this.items.remove(index);
                if (item != null) {
                    this.func_70296_d();
                }
            } else {
                Item item = new Item(stack);
                this.items.put(index, (Object)item);
                this.func_70296_d();
            }
        }
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("MaxPage", this.maxPage);
        NBTTagList list = new NBTTagList();
        for (Int2ObjectMap.Entry entry : this.items.int2ObjectEntrySet()) {
            Item item = (Item)entry.getValue();
            if (!item.isNotEmpty()) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("Index", entry.getIntKey());
            compound.func_74782_a("Stack", (NBTBase)item.getStack().serializeNBT());
            compound.func_74768_a("Count", item.getCount());
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.maxPage = nbt.func_74762_e("MaxPage");
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.items.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            int index = compound.func_74762_e("Index");
            ItemStack stack = new ItemStack(compound.func_74775_l("Stack"));
            int count = compound.func_74762_e("Count");
            this.items.put(index, (Object)new Item(stack, count));
        }
    }

    public int func_70297_j_() {
        return Config.slotStackLimit < 0 ? Integer.MAX_VALUE : Config.slotStackLimit;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public String func_70005_c_() {
        return "container.terrible_chest.terrible_chest";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public static final class Item {
        static final Item EMPTY = new Item(ItemStack.field_190927_a, 0);
        private ItemStack stack;
        private int count;

        Item(ItemStack stack, int count) {
            this.stack = stack.func_77946_l();
            this.count = count;
            this.stack.func_190920_e(1);
        }

        Item(ItemStack stack) {
            this(stack, stack.func_190916_E());
        }

        boolean isNotEmpty() {
            return !this.stack.func_190926_b() && this.count != 0;
        }

        ItemStack getStack() {
            return this.stack.func_77946_l();
        }

        int getCount() {
            return this.count;
        }

        void setCount(int count) {
            this.count = count;
        }
    }
}

