/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.inventory.container;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.config.Config;
import net.eidee.minecraft.terrible_chest.item.Items;
import net.eidee.minecraft.terrible_chest.util.IntUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TerribleChestContainer
extends Container {
    private IInventory inventory;
    private IInventory unlockInventory;
    private int[] data;

    public TerribleChestContainer(InventoryPlayer InventoryPlayer2) {
        this(InventoryPlayer2, (IInventory)new DummyInventory());
    }

    public TerribleChestContainer(InventoryPlayer InventoryPlayer2, IInventory inventory) {
        int j;
        int i;
        this.inventory = inventory;
        this.unlockInventory = new InventoryBasic("", false, 1);
        this.data = new int[this.inventory.func_174890_g()];
        this.inventory.func_174889_b(InventoryPlayer2.field_70458_d);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(this.inventory, j + i * 9, 8 + j * 18, 34 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)InventoryPlayer2, j + i * 9 + 9, 8 + j * 18, 100 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)InventoryPlayer2, i, 8 + i * 18, 158));
        }
        this.func_75146_a(new Slot(this.unlockInventory, 0, 183, 35));
    }

    public void setPage(int page) {
        int maxPage = this.inventory.func_174887_a_(28);
        int _page = MathHelper.func_76125_a((int)page, (int)0, (int)(maxPage - 1));
        this.inventory.func_174885_b(27, _page);
    }

    public void unlockMaxPage() {
        int maxPage;
        ItemStack stack = this.unlockInventory.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.DIAMOND_SPHERE && (maxPage = this.inventory.func_174887_a_(28)) < Config.maxPageLimit) {
            stack.func_190918_g(1);
            this.inventory.func_174885_b(28, maxPage + 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IInventory getChestInventory() {
        return this.inventory;
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_175173_a((Container)this, this.inventory);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.data.length; ++i) {
            int value = this.inventory.func_174887_a_(i);
            if (this.data[i] == value) continue;
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71112_a((Container)this, i, value);
                this.data[i] = value;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id >= 0 && id <= 30) {
            this.inventory.func_174885_b(id, data);
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.inventory.func_70300_a(playerIn);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_174886_c(playerIn);
        ItemStack stack = this.unlockInventory.func_70304_b(0);
        if (!stack.func_190926_b() && !playerIn.func_191521_c(stack)) {
            playerIn.func_71019_a(stack, true);
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75222_d >= 27;
    }

    public boolean func_94531_b(Slot slotIn) {
        return slotIn.field_75222_d >= 27;
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        IntStream stream = IntStream.range(startIndex, endIndex);
        if (reverseDirection) {
            stream = stream.map(i -> endIndex - i + startIndex - 1);
        }
        PrimitiveIterator.OfInt it = stream.iterator();
        boolean result = false;
        IntArrayList emptySlots = new IntArrayList(endIndex - startIndex);
        while (it.hasNext() && !stack.func_190926_b()) {
            int count;
            int index = it.nextInt();
            if (index < 0 || index >= 63) continue;
            Slot slot = this.func_75139_a(index);
            ItemStack stackInSlot = slot.func_75211_c();
            if (stackInSlot.func_190926_b()) {
                emptySlots.add(index);
                continue;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) continue;
            if (index < 27) {
                count = this.inventory.func_174887_a_(index);
                int limit = Config.slotStackLimit - count;
                if (limit == 0) continue;
                int size = IntUtil.minUnsigned(stack.func_190916_E(), limit);
                this.inventory.func_174885_b(index, count + size);
                stack.func_190918_g(size);
                slot.func_75218_e();
                result = true;
                continue;
            }
            count = stackInSlot.func_190916_E();
            int max = Math.min(stackInSlot.func_77976_d(), slot.func_75219_a());
            int limit = max - count;
            if (limit == 0) continue;
            int size = Math.min(stack.func_190916_E(), limit);
            stackInSlot.func_190917_f(size);
            stack.func_190918_g(size);
            slot.func_75218_e();
            result = true;
        }
        if (!stack.func_190926_b()) {
            IntListIterator emptiesIt = emptySlots.iterator();
            while (emptiesIt.hasNext()) {
                int emptySlot = emptiesIt.nextInt();
                Slot slot = this.func_75139_a(emptySlot);
                if (emptySlot < 27) {
                    slot.func_75215_d(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    this.inventory.func_174885_b(emptySlot, stack.func_190916_E());
                    stack.func_190920_e(0);
                    result = true;
                } else {
                    int size = Math.min(stack.func_190916_E(), slot.func_75219_a());
                    slot.func_75215_d(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size));
                    stack.func_190918_g(size);
                    result = true;
                }
                if (!stack.func_190926_b()) continue;
                break;
            }
        }
        return result;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (index < 27) {
                ItemStack copy = stackInSlot.func_77946_l();
                int count = this.inventory.func_174887_a_(index);
                int size = IntUtil.minUnsigned(count, stackInSlot.func_77976_d());
                copy.func_190920_e(size);
                if (!this.func_75135_a(copy, 27, 63, true)) {
                    return ItemStack.field_190927_a;
                }
                int newCount = count - (size - copy.func_190916_E());
                this.inventory.func_174885_b(index, newCount);
                if (newCount == 0) {
                    stackInSlot.func_190920_e(0);
                }
            } else if (!this.func_75135_a(stackInSlot, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (stackInSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= 0 && slotId < 27) {
            InventoryPlayer InventoryPlayer2 = player.field_71071_by;
            if (clickTypeIn == ClickType.PICKUP) {
                ItemStack copy;
                int _dragType = dragType;
                if (this.inventory.func_174887_a_(29) != -1) {
                    _dragType = 2;
                }
                ItemStack stack = InventoryPlayer2.func_70445_o().func_77946_l();
                Slot slot = this.func_75139_a(slotId);
                ItemStack stackInSlot = slot.func_75211_c();
                if (_dragType == 0) {
                    if (stack.func_190926_b()) {
                        if (!stackInSlot.func_190926_b()) {
                            ItemStack result = slot.func_75209_a(stackInSlot.func_77976_d());
                            InventoryPlayer2.func_70437_b(result);
                            return result;
                        }
                    } else if (stackInSlot.func_190926_b()) {
                        int count = stack.func_190916_E();
                        stack.func_190920_e(1);
                        slot.func_75215_d(stack);
                        this.inventory.func_174885_b(slotId, count);
                        InventoryPlayer2.func_70437_b(ItemStack.field_190927_a);
                    } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot) && this.func_75135_a(stack, slotId, slotId + 1, false)) {
                        InventoryPlayer2.func_70437_b(stack);
                        return stack;
                    }
                } else if (_dragType == 1) {
                    if (stack.func_190926_b()) {
                        if (!stackInSlot.func_190926_b()) {
                            int count = this.inventory.func_174887_a_(slotId);
                            int amount = IntUtil.minUnsigned(count, stackInSlot.func_77976_d()) / 2;
                            ItemStack result = slot.func_75209_a(amount);
                            InventoryPlayer2.func_70437_b(result);
                            return result;
                        }
                    } else {
                        if (stackInSlot.func_190926_b()) {
                            ItemStack _stack = stack.func_77979_a(1);
                            slot.func_75215_d(_stack);
                            InventoryPlayer2.func_70437_b(stack);
                            return stack;
                        }
                        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                            int count = this.inventory.func_174887_a_(slotId);
                            if (Integer.compareUnsigned(Config.slotStackLimit, 0) > 0) {
                                stack.func_190918_g(1);
                                this.inventory.func_174885_b(slotId, count + 1);
                                InventoryPlayer2.func_70437_b(stack);
                                return stack;
                            }
                        }
                    }
                } else if (_dragType == 2) {
                    int actualSlotId = slotId + this.inventory.func_174887_a_(27) * 27;
                    int swapTarget = this.inventory.func_174887_a_(29);
                    if (swapTarget >= 0) {
                        int value = 0x40000000 + (swapTarget << 15) + actualSlotId;
                        this.inventory.func_174885_b(29, value);
                        this.func_75142_b();
                    } else {
                        this.inventory.func_174885_b(29, actualSlotId);
                    }
                } else if (_dragType == 3 && !stackInSlot.func_190926_b() && this.func_75135_a(copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)1), 27, 63, true)) {
                    int newCount = this.inventory.func_174887_a_(slotId) - 1;
                    this.inventory.func_174885_b(slotId, newCount);
                    if (newCount == 0) {
                        slot.func_75215_d(ItemStack.field_190927_a);
                    }
                }
                return ItemStack.field_190927_a;
            }
            if (clickTypeIn == ClickType.THROW) {
                this.inventory.func_174885_b(29, -1);
                ItemStack stack = InventoryPlayer2.func_70445_o();
                if (stack.func_190926_b()) {
                    Slot slot = this.func_75139_a(slotId);
                    ItemStack stackInSlot = slot.func_75211_c();
                    if (!stackInSlot.func_190926_b()) {
                        int count = this.inventory.func_174887_a_(slotId);
                        int stackSize = dragType == 1 ? stackInSlot.func_77976_d() : 1;
                        int dropSize = IntUtil.minUnsigned(stackSize, count);
                        ItemStack dropStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)dropSize);
                        player.func_71019_a(dropStack, false);
                        int newCount = count - dropSize;
                        this.inventory.func_174885_b(slotId, newCount);
                        if (newCount == 0) {
                            slot.func_75215_d(ItemStack.field_190927_a);
                        }
                    }
                    return ItemStack.field_190927_a;
                }
            } else {
                if (clickTypeIn == ClickType.QUICK_MOVE) {
                    this.inventory.func_174885_b(29, -1);
                    if (dragType == 2) {
                        ItemStack stackInSlot = this.func_75139_a(slotId).func_75211_c().func_77946_l();
                        if (!stackInSlot.func_190926_b()) {
                            for (int i = 0; i < 27; ++i) {
                                ItemStack stackInPlayer = this.func_75139_a(i).func_75211_c();
                                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackInPlayer)) continue;
                                while (!this.func_82846_b(player, i).func_190926_b()) {
                                }
                            }
                        }
                        return ItemStack.field_190927_a;
                    }
                    this.func_82846_b(player, slotId);
                    return ItemStack.field_190927_a;
                }
                if (clickTypeIn == ClickType.CLONE || clickTypeIn == ClickType.PICKUP_ALL || clickTypeIn == ClickType.QUICK_CRAFT || clickTypeIn == ClickType.SWAP) {
                    this.inventory.func_174885_b(29, -1);
                    return ItemStack.field_190927_a;
                }
            }
        } else if (slotId >= 27 && slotId < 63) {
            this.inventory.func_174885_b(29, -1);
            if (clickTypeIn == ClickType.PICKUP) {
                ItemStack copy;
                ItemStack stackInSlot;
                if (dragType == 3 && !(stackInSlot = this.func_75139_a(slotId).func_75211_c()).func_190926_b() && this.func_75135_a(copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)1), 0, 27, false)) {
                    stackInSlot.func_190918_g(1);
                }
            } else if (clickTypeIn == ClickType.QUICK_MOVE && dragType == 2) {
                ItemStack stackInSlot = this.func_75139_a(slotId).func_75211_c().func_77946_l();
                if (!stackInSlot.func_190926_b()) {
                    for (int i = 27; i < 63; ++i) {
                        ItemStack stackInPlayer = this.func_75139_a(i).func_75211_c();
                        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackInPlayer)) continue;
                        this.func_82846_b(player, i);
                    }
                }
                return ItemStack.field_190927_a;
            }
        } else {
            this.inventory.func_174885_b(29, -1);
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    private static class DummyInventory
    extends InventoryBasic {
        private int[] data = new int[30];

        DummyInventory() {
            super("dummy", false, 27);
            this.data[27] = 0;
            this.data[28] = 1;
            this.data[29] = -1;
        }

        public int func_174887_a_(int id) {
            return this.data[id];
        }

        public void func_174885_b(int id, int value) {
            this.data[id] = value;
        }

        public int func_174890_g() {
            return 30;
        }
    }
}

