/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.capability.Capabilities;
import net.eidee.minecraft.terrible_chest.config.Config;
import net.eidee.minecraft.terrible_chest.inventory.ItemHandler;
import net.eidee.minecraft.terrible_chest.inventory.TerribleChestInventory;
import net.eidee.minecraft.terrible_chest.inventory.container.TerribleChestContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TerribleChestTileEntity
extends TileEntity
implements ITickable {
    public static final int DATA_PAGE = 27;
    public static final int DATA_MAX_PAGE = 28;
    public static final int DATA_SWAP_TARGET = 29;
    public static final int SWAP_EXEC_FLAG = 0x40000000;
    private UUID ownerId;
    private int page;
    private int swapTarget = -1;

    private static List<TileEntity> getAllNeighborInventoryTileEntity(World world, BlockPos pos) {
        EnumFacing[] directions;
        ArrayList list = Lists.newArrayList();
        for (EnumFacing direction : directions = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}) {
            TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(direction));
            if (!(tileEntity instanceof IInventory)) continue;
            list.add(tileEntity);
        }
        return list;
    }

    private static Iterable<IItemHandler> getItemHandler(TileEntity tileEntity, EnumFacing side) {
        ArrayList list = Lists.newArrayListWithCapacity((int)1);
        IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        if (capability != null) {
            list.add(capability);
        }
        return list;
    }

    @Nullable
    private static ISidedInventory getSidedInventory(TileEntity tileEntity) {
        ISidedInventory sidedInventory = null;
        if (tileEntity instanceof ISidedInventory) {
            sidedInventory = (ISidedInventory)tileEntity;
        }
        return sidedInventory;
    }

    private static boolean canInsertItem(TileEntity tileEntity, EnumFacing side, ItemStack stackInSlot, ItemStack insertStack) {
        ISidedInventory sidedInventory = TerribleChestTileEntity.getSidedInventory(tileEntity);
        if (sidedInventory != null) {
            for (int slot : sidedInventory.func_180463_a(side)) {
                if (sidedInventory.func_70301_a(slot) != stackInSlot || sidedInventory.func_180462_a(slot, insertStack, side)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canExtractItem(TileEntity tileEntity, EnumFacing side, ItemStack stackInSlot) {
        ISidedInventory sidedInventory = TerribleChestTileEntity.getSidedInventory(tileEntity);
        if (sidedInventory != null) {
            for (int slot : sidedInventory.func_180463_a(side)) {
                if (sidedInventory.func_70301_a(slot) != stackInSlot || sidedInventory.func_180461_b(slot, stackInSlot, side)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isUsableByPlayer(EntityPlayer player) {
        BlockPos pos;
        World world = Objects.requireNonNull(this.func_145831_w());
        if (world.func_175625_s(pos = this.func_174877_v()) != this || !Objects.equals(player.func_110124_au(), this.ownerId)) {
            return false;
        }
        return player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    private void itemDeliver(World world, TerribleChestInventory inventory) {
        Inventory _inventory = new Inventory(this, inventory);
        for (int i = 0; i < _inventory.func_70302_i_(); ++i) {
            ItemStack stack = _inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            for (TileEntity tileEntity : TerribleChestTileEntity.getAllNeighborInventoryTileEntity(world, this.func_174877_v())) {
                EnumFacing[] sides;
                for (EnumFacing side : sides = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH}) {
                    for (IItemHandler itemHandler : TerribleChestTileEntity.getItemHandler(tileEntity, side)) {
                        for (int j = 0; j < itemHandler.getSlots(); ++j) {
                            ItemStack result;
                            ItemStack stackInSlot = itemHandler.getStackInSlot(j);
                            if (stackInSlot.func_190926_b() || !TerribleChestTileEntity.canInsertItem(tileEntity, side, stackInSlot, stack) || (result = itemHandler.insertItem(j, stack, false)) == stack) continue;
                            _inventory.func_70298_a(i, 1);
                            return;
                        }
                    }
                }
            }
        }
    }

    private void itemCollection(World world, TerribleChestInventory inventory) {
        Inventory _inventory = new Inventory(this, inventory);
        for (TileEntity tileEntity : TerribleChestTileEntity.getAllNeighborInventoryTileEntity(world, this.func_174877_v())) {
            EnumFacing side = EnumFacing.DOWN;
            for (IItemHandler itemHandler : TerribleChestTileEntity.getItemHandler(tileEntity, side)) {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                    if (!TerribleChestTileEntity.canExtractItem(tileEntity, side, stackInSlot)) continue;
                    for (int j = 0; j < _inventory.func_70302_i_(); ++j) {
                        ItemStack stack = _inventory.func_70301_a(j);
                        int itemCount = _inventory.getItemCount(j);
                        if (stack.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot) || itemCount == -1) continue;
                        _inventory.setItemCount(j, itemCount + 1);
                        itemHandler.extractItem(i, 1, false);
                        return;
                    }
                }
            }
        }
    }

    @Nullable
    private TerribleChestInventory getTerribleChestInventory() {
        World world;
        EntityPlayer owner;
        if (this.ownerId != null && (owner = (world = Objects.requireNonNull(this.func_145831_w())).func_152378_a(this.ownerId)) != null) {
            return (TerribleChestInventory)owner.getCapability(Capabilities.TERRIBLE_CHEST, null);
        }
        return null;
    }

    public void setOwnerId(UUID ownerId) {
        this.ownerId = ownerId;
    }

    public boolean isOwner(EntityPlayer player) {
        return Objects.equals(this.ownerId, player.func_110124_au());
    }

    @Nullable
    public TerribleChestContainer createContainer(InventoryPlayer inventoryPlayer) {
        TerribleChestInventory capability = (TerribleChestInventory)inventoryPlayer.field_70458_d.getCapability(Capabilities.TERRIBLE_CHEST, null);
        if (capability != null) {
            return new TerribleChestContainer(inventoryPlayer, new Inventory(this, capability));
        }
        return null;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("container.terrible_chest.terrible_chest", new Object[0]);
    }

    public void func_73660_a() {
        if (!Config.stopItemCollectionAndDeliver) {
            TerribleChestInventory inventory;
            World world = Objects.requireNonNull(this.func_145831_w());
            if (!world.field_72995_K && (inventory = this.getTerribleChestInventory()) != null) {
                if (world.func_175640_z(this.func_174877_v())) {
                    this.itemDeliver(world, inventory);
                } else {
                    this.itemCollection(world, inventory);
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.ownerId = compound.func_186857_a("OwnerId");
        this.page = compound.func_74762_e("Page");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.ownerId != null) {
            compound.func_186854_a("OwnerId", this.ownerId);
        }
        compound.func_74768_a("Page", this.page);
        return compound;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && Config.useItemHandlerCapability) {
            TerribleChestInventory inventory = this.getTerribleChestInventory();
            return inventory != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        TerribleChestInventory inventory;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && Config.useItemHandlerCapability && (inventory = this.getTerribleChestInventory()) != null) {
            return (T)new ItemHandler(inventory.createInventory());
        }
        return (T)super.getCapability(capability, facing);
    }

    private static class Inventory
    implements IInventory {
        private TerribleChestTileEntity tileEntity;
        private TerribleChestInventory inventory;

        Inventory(TerribleChestTileEntity tileEntity, TerribleChestInventory inventory) {
            this.tileEntity = tileEntity;
            this.inventory = inventory;
        }

        private int getOffset() {
            return this.tileEntity.page * 27;
        }

        private int getItemCount(int index) {
            return this.inventory.getItemCount(this.getOffset() + index);
        }

        private void setItemCount(int index, int count) {
            this.inventory.setItemCount(this.getOffset() + index, count);
        }

        private void swap(int index1, int index2) {
            int offset = this.getOffset();
            this.inventory.swap(offset + index1, offset + index2);
        }

        public int func_70302_i_() {
            return 27;
        }

        public boolean func_191420_l() {
            int offset = this.getOffset();
            for (int i = 0; i < 27; ++i) {
                if (this.inventory.func_70301_a(offset + i).func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return this.inventory.func_70301_a(this.getOffset() + index);
        }

        public ItemStack func_70298_a(int index, int count) {
            return this.inventory.func_70298_a(this.getOffset() + index, count);
        }

        public ItemStack func_70304_b(int index) {
            return this.inventory.func_70304_b(this.getOffset() + index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.inventory.func_70299_a(this.getOffset() + index, stack);
        }

        public void func_70296_d() {
            this.inventory.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return this.tileEntity.isUsableByPlayer(player);
        }

        public void func_174888_l() {
            int offset = this.getOffset();
            for (int i = 0; i < 27; ++i) {
                this.inventory.func_70304_b(offset + i);
            }
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public int func_70297_j_() {
            return Integer.MAX_VALUE;
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return true;
        }

        public int func_174887_a_(int index) {
            if (index >= 0 && index < 27) {
                return this.getItemCount(index);
            }
            if (index == 27) {
                return this.tileEntity.page;
            }
            if (index == 28) {
                return this.inventory.getMaxPage();
            }
            if (index == 29) {
                return this.tileEntity.swapTarget;
            }
            return 0;
        }

        public void func_174885_b(int index, int value) {
            if (index >= 0 && index < 27) {
                this.setItemCount(index, value);
            } else if (index == 27) {
                this.tileEntity.page = value;
            } else if (index == 28) {
                this.inventory.setMaxPage(value);
            } else if (index == 29) {
                if ((value & 0x40000000) != 0) {
                    int _value = value - 0x40000000;
                    int index1 = _value >> 15;
                    int index2 = _value & Short.MAX_VALUE;
                    this.inventory.swap(index1, index2);
                    this.tileEntity.swapTarget = -1;
                } else {
                    this.tileEntity.swapTarget = value;
                }
            }
        }

        public int func_174890_g() {
            return 30;
        }

        public String func_70005_c_() {
            return "container.terrible_chest.terrible_chest";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }
    }
}

