/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.capability;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.capability.TerribleChestItem;
import net.eidee.minecraft.terrible_chest.capability.logic.TerribleChestItemsLogic;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TerribleChestItemsCapability
implements INBTSerializable<CompoundNBT> {
    public static final ResourceLocation REGISTRY_KEY = new ResourceLocation("terrible_chest:terrible_chest");
    private final Int2ObjectMap<TerribleChestItem> items = new Int2ObjectOpenHashMap();
    private final TerribleChestItemsLogic logic;

    public <T extends TerribleChestItemsLogic> TerribleChestItemsCapability(TerribleChestItemsLogic.Factory<T> factory) {
        this.logic = factory.create(this.items);
    }

    public TerribleChestItemsLogic getLogic() {
        return this.logic;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (Int2ObjectMap.Entry entry : this.items.int2ObjectEntrySet()) {
            int index = entry.getIntKey();
            TerribleChestItem item = (TerribleChestItem)entry.getValue();
            if (!item.isNotEmpty()) continue;
            CompoundNBT compound = item.serializeNBT();
            compound.func_74768_a("Index", index);
            list.add((Object)compound);
        }
        nbt.func_218657_a("Items", (INBT)list);
        return this.logic.writeToNBT(nbt);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.logic.readFromNBT(nbt);
        ListNBT list = nbt.func_150295_c("Items", 10);
        this.items.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT compound = list.func_150305_b(i);
            int index = compound.func_74762_e("Index");
            TerribleChestItem item = TerribleChestItem.read(compound);
            if (!item.isNotEmpty()) continue;
            this.items.put(index, (Object)item);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        private final Capability<TerribleChestItemsCapability> _cap;
        private TerribleChestItemsCapability instance;

        public Provider(Capability<TerribleChestItemsCapability> _cap) {
            this._cap = _cap;
            this.instance = (TerribleChestItemsCapability)this._cap.getDefaultInstance();
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return this._cap.orEmpty(cap, LazyOptional.of(() -> this.instance));
        }

        public CompoundNBT serializeNBT() {
            INBT inbt = this._cap.writeNBT((Object)this.instance, null);
            return inbt instanceof CompoundNBT ? (CompoundNBT)inbt : new CompoundNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this._cap.readNBT((Object)this.instance, null, (INBT)nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<TerribleChestItemsCapability> {
        @Nullable
        public INBT writeNBT(Capability<TerribleChestItemsCapability> capability, TerribleChestItemsCapability instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<TerribleChestItemsCapability> capability, TerribleChestItemsCapability instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                instance.deserializeNBT((CompoundNBT)nbt);
            }
        }
    }
}

