/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.capability.logic;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Comparator;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.capability.TerribleChestItem;
import net.eidee.minecraft.terrible_chest.config.Config;
import net.eidee.minecraft.terrible_chest.util.IntUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TerribleChestItemsLogic {
    protected Int2ObjectMap<TerribleChestItem> items;

    public TerribleChestItemsLogic(Int2ObjectMap<TerribleChestItem> items) {
        this.items = items;
    }

    protected abstract int getInventorySize();

    public IInventory createInventory() {
        return new IInventory(){

            public int func_70302_i_() {
                return TerribleChestItemsLogic.this.getInventorySize();
            }

            public boolean func_191420_l() {
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    if (!((TerribleChestItem)TerribleChestItemsLogic.this.items.getOrDefault(i, (Object)TerribleChestItem.EMPTY)).isNotEmpty()) continue;
                    return false;
                }
                return true;
            }

            public ItemStack func_70301_a(int index) {
                TerribleChestItem item = (TerribleChestItem)TerribleChestItemsLogic.this.items.getOrDefault(index, (Object)TerribleChestItem.EMPTY);
                if (item.isNotEmpty()) {
                    int itemCount = item.getCount();
                    int size = IntUtil.minUnsigned(this.func_70297_j_(), itemCount);
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)item.getStack(), (int)size);
                }
                return ItemStack.field_190927_a;
            }

            public ItemStack func_70298_a(int index, int count) {
                TerribleChestItem item;
                if (count > 0 && TerribleChestItemsLogic.this.isValidIndex(index) && (item = (TerribleChestItem)TerribleChestItemsLogic.this.items.getOrDefault(index, (Object)TerribleChestItem.EMPTY)).isNotEmpty()) {
                    ItemStack stack = item.getStack();
                    int itemCount = item.getCount();
                    int _count = IntUtil.minUnsigned(count, itemCount);
                    if (_count == itemCount) {
                        TerribleChestItemsLogic.this.items.remove(index);
                    }
                    item.setCount(itemCount - _count);
                    this.func_70296_d();
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)_count);
                }
                return ItemStack.field_190927_a;
            }

            public ItemStack func_70304_b(int index) {
                TerribleChestItem item;
                if (TerribleChestItemsLogic.this.isValidIndex(index) && (item = (TerribleChestItem)TerribleChestItemsLogic.this.items.remove(index)) != null) {
                    ItemStack stack = item.getStack();
                    int size = IntUtil.minUnsigned(stack.func_77976_d(), item.getCount());
                    this.func_70296_d();
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
                }
                return ItemStack.field_190927_a;
            }

            public void func_70299_a(int index, ItemStack stack) {
                if (TerribleChestItemsLogic.this.isValidIndex(index)) {
                    if (stack.func_190926_b()) {
                        TerribleChestItem item = (TerribleChestItem)TerribleChestItemsLogic.this.items.remove(index);
                        if (item != null) {
                            this.func_70296_d();
                        }
                    } else {
                        TerribleChestItem item = new TerribleChestItem(stack);
                        TerribleChestItemsLogic.this.items.put(index, (Object)item);
                        this.func_70296_d();
                    }
                }
            }

            public void func_70296_d() {
            }

            public boolean func_70300_a(PlayerEntity player) {
                return true;
            }

            public void func_174888_l() {
                TerribleChestItemsLogic.this.items.clear();
            }

            public int func_70297_j_() {
                return (int)Math.min(Integer.MAX_VALUE, (Long)Config.COMMON.slotStackLimit.get());
            }
        };
    }

    public boolean isValidIndex(int index) {
        return index >= 0 && index < this.getInventorySize();
    }

    public int getItemCount(int index) {
        return ((TerribleChestItem)this.items.getOrDefault(index, (Object)TerribleChestItem.EMPTY)).getCount();
    }

    public void setItemCount(int index, int count) {
        TerribleChestItem item = (TerribleChestItem)this.items.getOrDefault(index, (Object)TerribleChestItem.EMPTY);
        if (item.isNotEmpty()) {
            int _count = (int)Math.min((long)count, (Long)Config.COMMON.slotStackLimit.get());
            item.setCount(_count);
        }
    }

    public void swap(int index1, int index2) {
        TerribleChestItem item1 = (TerribleChestItem)this.items.remove(index1);
        TerribleChestItem item2 = (TerribleChestItem)this.items.remove(index2);
        if (item2 != null && item2.isNotEmpty()) {
            this.items.put(index1, (Object)item2);
        }
        if (item1 != null && item1.isNotEmpty()) {
            this.items.put(index2, (Object)item1);
        }
    }

    public void sort(Comparator<TerribleChestItem> comparator, int index1, int index2) {
        if (index1 >= 0 && index2 >= 0 && index1 < index2 && index2 <= this.getInventorySize()) {
            int length;
            int h = length = index2 - index1;
            boolean swap = false;
            while (h > 1 || swap) {
                if (h > 1) {
                    h = h * 10 / 13;
                }
                swap = false;
                for (int i = 0; i < length - h; ++i) {
                    int j = index1 + i;
                    int k = j + h;
                    TerribleChestItem item1 = (TerribleChestItem)this.items.getOrDefault(j, (Object)TerribleChestItem.EMPTY);
                    TerribleChestItem item2 = (TerribleChestItem)this.items.getOrDefault(k, (Object)TerribleChestItem.EMPTY);
                    if (ItemHandlerHelper.canItemStacksStack((ItemStack)item1.getStack(), (ItemStack)item2.getStack())) {
                        long slotStackLimit = (Long)Config.COMMON.slotStackLimit.get();
                        int item1Count = item1.getCount();
                        int item2Count = item2.getCount();
                        if (Long.compareUnsigned(item1Count, slotStackLimit) < 0) {
                            int limit = (int)(slotStackLimit - (long)item1Count);
                            int size = IntUtil.minUnsigned(item2Count, limit);
                            item1.setCount(item1Count + size);
                            item2.setCount(item2Count - size);
                            swap = true;
                        }
                    }
                    if ((!item1.isNotEmpty() || !item2.isNotEmpty()) && (!item1.isEmpty() || !item2.isNotEmpty()) || !item1.isEmpty() && comparator.compare(item1, item2) <= 0) continue;
                    this.swap(j, k);
                    swap = true;
                }
            }
        }
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        return nbt;
    }

    public void readFromNBT(CompoundNBT nbt) {
    }

    public static interface Factory<T extends TerribleChestItemsLogic> {
        public T create(Int2ObjectMap<TerribleChestItem> var1);
    }
}

