/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.gui;

import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.config.KeyBindings;
import net.eidee.minecraft.terrible_chest.inventory.container.TerribleChestContainer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public abstract class TerribleChestScreen
extends ContainerScreen<TerribleChestContainer> {
    private static final IntObjectMap<KeyBinding> sortKeys;

    public TerribleChestScreen(TerribleChestContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (type == ClickType.PICKUP && mouseButton == 0) {
            if (slotId >= 0 && slotId < ((TerribleChestContainer)this.field_147002_h).getChestInventory().func_70302_i_()) {
                if (TerribleChestScreen.hasAltDown()) {
                    super.func_184098_a(slotIn, slotId, 2, type);
                    return;
                }
                if (TerribleChestScreen.hasControlDown()) {
                    super.func_184098_a(slotIn, slotId, 3, type);
                    return;
                }
            } else if (slotId >= ((TerribleChestContainer)this.field_147002_h).getChestInventory().func_70302_i_() && slotId < ((TerribleChestContainer)this.field_147002_h).getTotalSlotSize() && TerribleChestScreen.hasControlDown()) {
                super.func_184098_a(slotIn, slotId, 3, type);
                return;
            }
        } else if (type == ClickType.QUICK_MOVE && mouseButton == 0) {
            if (slotId >= 0 && slotId < ((TerribleChestContainer)this.field_147002_h).getTotalSlotSize() && TerribleChestScreen.hasControlDown()) {
                super.func_184098_a(slotIn, slotId, 2, type);
                return;
            }
        } else if (type == ClickType.CLONE) {
            super.func_184098_a(slotIn, slotId, 1, type);
            return;
        }
        super.func_184098_a(slotIn, slotId, mouseButton, type);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        Iterable entries = sortKeys.entries();
        for (IntObjectMap.PrimitiveEntry entry : entries) {
            KeyBinding keyBinding = (KeyBinding)entry.value();
            if (!keyBinding.func_197976_a(p_keyPressed_1_, p_keyPressed_2_)) continue;
            super.func_184098_a(null, 0, entry.key(), ClickType.CLONE);
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        super.render(p_render_1_, p_render_2_, p_render_3_);
        this.func_191948_b(p_render_1_, p_render_2_);
    }

    public void renderTooltip(List<String> textLines, int x, int y, FontRenderer font) {
        Slot slot = this.getSlotUnderMouse();
        if (slot != null && Objects.equals(slot.field_75224_c, ((TerribleChestContainer)this.field_147002_h).getChestInventory())) {
            long count = (long)((TerribleChestContainer)this.field_147002_h).getData(slot.getSlotIndex()) & 0xFFFFFFFFL;
            textLines.add(1, I18n.func_135052_a((String)"gui.terrible_chest.terrible_chest.count", (Object[])new Object[]{count}));
        }
        super.renderTooltip(textLines, x, y, font);
    }

    static {
        IntObjectHashMap map = new IntObjectHashMap();
        map.put(0, (Object)KeyBindings.SORT_0);
        map.put(1, (Object)KeyBindings.SORT_1);
        map.put(2, (Object)KeyBindings.SORT_2);
        map.put(3, (Object)KeyBindings.SORT_3);
        map.put(4, (Object)KeyBindings.SORT_4);
        map.put(5, (Object)KeyBindings.SORT_5);
        map.put(6, (Object)KeyBindings.SORT_6);
        map.put(7, (Object)KeyBindings.SORT_7);
        map.put(8, (Object)KeyBindings.SORT_8);
        map.put(9, (Object)KeyBindings.SORT_9);
        sortKeys = map;
    }
}

