/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.inventory.container;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.config.Config;
import net.eidee.minecraft.terrible_chest.inventory.container.ContainerTypes;
import net.eidee.minecraft.terrible_chest.tileentity.TerribleChestTileEntity;
import net.eidee.minecraft.terrible_chest.util.IntUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TerribleChestContainer
extends Container {
    protected final PlayerInventory playerInventory;
    protected final IInventory chestInventory;
    protected final IIntArray data;
    protected final int totalSlotSize;
    protected int swapIndex1;
    protected int swapIndex2;

    public TerribleChestContainer(int id, PlayerInventory playerInventory, IInventory chestInventory, IIntArray data) {
        super(ContainerTypes.TERRIBLE_CHEST, id);
        this.playerInventory = playerInventory;
        this.chestInventory = chestInventory;
        this.data = data;
        this.totalSlotSize = chestInventory.func_70302_i_() + playerInventory.field_70462_a.size();
        this.chestInventory.func_174889_b(this.playerInventory.field_70458_d);
        this.swapIndex1 = -1;
        this.swapIndex2 = -1;
        this.func_216961_a(this.data);
    }

    private void swapSlot() {
        if (this.swapIndex1 >= 0 && this.swapIndex2 >= 0) {
            this.playerInventory.field_70458_d.func_184185_a(SoundEvents.field_187909_gi, 0.25f, 1.0f);
            if (this.chestInventory instanceof TerribleChestTileEntity.TerribleChestInventoryWrapper) {
                ((TerribleChestTileEntity.TerribleChestInventoryWrapper)this.chestInventory).swap(this.swapIndex1, this.swapIndex2);
                this.func_75142_b();
            }
        }
        this.swapIndex1 = -1;
        this.swapIndex2 = -1;
    }

    private void sortInventory(int sortType) {
        this.playerInventory.field_70458_d.func_184185_a(SoundEvents.field_187909_gi, 0.25f, 1.0f);
        if (this.chestInventory instanceof TerribleChestTileEntity.TerribleChestInventoryWrapper) {
            ((TerribleChestTileEntity.TerribleChestInventoryWrapper)this.chestInventory).sort(sortType);
            this.func_75142_b();
        }
    }

    protected void setSwapIndex(int swapIndex1, int swapIndex2) {
        this.swapIndex1 = swapIndex1;
        this.swapIndex2 = swapIndex2;
    }

    public IInventory getChestInventory() {
        return this.chestInventory;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getData(int index) {
        return this.data.func_221476_a(index);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTotalSlotSize() {
        return this.totalSlotSize;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSwapIndex1() {
        return this.swapIndex1;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.chestInventory.func_70300_a(playerIn);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.chestInventory.func_174886_c(playerIn);
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.chestInventory;
    }

    public boolean func_94531_b(Slot slotIn) {
        return slotIn.field_75224_c != this.chestInventory;
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        IntStream stream = IntStream.range(startIndex, endIndex);
        if (reverseDirection) {
            stream = stream.map(i -> endIndex - i + startIndex - 1);
        }
        PrimitiveIterator.OfInt it = stream.iterator();
        boolean result = false;
        IntArrayList emptySlots = new IntArrayList(endIndex - startIndex);
        while (it.hasNext() && !stack.func_190926_b()) {
            int count;
            int index = it.nextInt();
            if (index < 0 || index >= this.totalSlotSize) continue;
            Slot slot = this.func_75139_a(index);
            ItemStack stackInSlot = slot.func_75211_c();
            if (stackInSlot.func_190926_b()) {
                emptySlots.add(index);
                continue;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) continue;
            if (index < this.chestInventory.func_70302_i_()) {
                count = this.data.func_221476_a(index);
                int limit = (int)((Long)Config.COMMON.slotStackLimit.get() - (long)count);
                if (limit == 0) continue;
                int size = IntUtil.minUnsigned(stack.func_190916_E(), limit);
                this.data.func_221477_a(index, count + size);
                stack.func_190918_g(size);
                slot.func_75218_e();
                result = true;
                continue;
            }
            count = stackInSlot.func_190916_E();
            int max = Math.min(stackInSlot.func_77976_d(), slot.func_75219_a());
            int limit = max - count;
            if (limit == 0) continue;
            int size = Math.min(stack.func_190916_E(), limit);
            stackInSlot.func_190917_f(size);
            stack.func_190918_g(size);
            slot.func_75218_e();
            result = true;
        }
        if (!stack.func_190926_b()) {
            IntListIterator emptiesIt = emptySlots.iterator();
            while (emptiesIt.hasNext()) {
                int emptySlot = emptiesIt.nextInt();
                Slot slot = this.func_75139_a(emptySlot);
                if (emptySlot < this.chestInventory.func_70302_i_()) {
                    slot.func_75215_d(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    this.data.func_221477_a(emptySlot, stack.func_190916_E());
                    stack.func_190920_e(0);
                    result = true;
                } else {
                    int size = Math.min(stack.func_190916_E(), slot.func_75219_a());
                    slot.func_75215_d(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size));
                    stack.func_190918_g(size);
                    result = true;
                }
                if (!stack.func_190926_b()) continue;
                break;
            }
        }
        return result;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (index < this.chestInventory.func_70302_i_()) {
                ItemStack copy = stackInSlot.func_77946_l();
                int count = this.data.func_221476_a(index);
                int size = IntUtil.minUnsigned(count, stackInSlot.func_77976_d());
                copy.func_190920_e(size);
                if (!this.func_75135_a(copy, this.chestInventory.func_70302_i_(), this.totalSlotSize, true)) {
                    return ItemStack.field_190927_a;
                }
                int newCount = count - (size - copy.func_190916_E());
                this.data.func_221477_a(index, newCount);
                if (newCount == 0) {
                    stackInSlot.func_190920_e(0);
                }
            } else if (!this.func_75135_a(stackInSlot, 0, this.chestInventory.func_70302_i_(), false)) {
                return ItemStack.field_190927_a;
            }
            if (stackInSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (slotId >= 0 && slotId < this.chestInventory.func_70302_i_()) {
            PlayerInventory playerInventory = player.field_71071_by;
            if (clickTypeIn == ClickType.PICKUP) {
                ItemStack copy;
                int _dragType = dragType;
                if (this.swapIndex1 != -1) {
                    _dragType = 2;
                }
                ItemStack stack = playerInventory.func_70445_o().func_77946_l();
                Slot slot = this.func_75139_a(slotId);
                ItemStack stackInSlot = slot.func_75211_c();
                if (_dragType == 0) {
                    if (stack.func_190926_b()) {
                        if (!stackInSlot.func_190926_b()) {
                            ItemStack result = slot.func_75209_a(stackInSlot.func_77976_d());
                            playerInventory.func_70437_b(result);
                            return result;
                        }
                    } else if (stackInSlot.func_190926_b()) {
                        int count = stack.func_190916_E();
                        stack.func_190920_e(1);
                        slot.func_75215_d(stack);
                        this.data.func_221477_a(slotId, count);
                        playerInventory.func_70437_b(ItemStack.field_190927_a);
                    } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot) && this.func_75135_a(stack, slotId, slotId + 1, false)) {
                        playerInventory.func_70437_b(stack);
                        return stack;
                    }
                } else if (_dragType == 1) {
                    if (stack.func_190926_b()) {
                        if (!stackInSlot.func_190926_b()) {
                            int count = this.data.func_221476_a(slotId);
                            int amount = IntUtil.minUnsigned(count, stackInSlot.func_77976_d()) / 2;
                            ItemStack result = slot.func_75209_a(amount);
                            playerInventory.func_70437_b(result);
                            return result;
                        }
                    } else {
                        int count;
                        if (stackInSlot.func_190926_b()) {
                            ItemStack _stack = stack.func_77979_a(1);
                            slot.func_75215_d(_stack);
                            playerInventory.func_70437_b(stack);
                            return stack;
                        }
                        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot) && Long.compareUnsigned(count = this.data.func_221476_a(slotId), (Long)Config.COMMON.slotStackLimit.get()) < 0) {
                            stack.func_190918_g(1);
                            this.data.func_221477_a(slotId, count + 1);
                            playerInventory.func_70437_b(stack);
                            return stack;
                        }
                    }
                } else if (_dragType == 2) {
                    if (this.swapIndex1 >= 0) {
                        this.setSwapIndex(this.swapIndex1, slotId);
                        this.swapSlot();
                    } else {
                        this.setSwapIndex(slotId, -1);
                    }
                } else if (_dragType == 3 && !stackInSlot.func_190926_b() && this.func_75135_a(copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)1), this.chestInventory.func_70302_i_(), this.totalSlotSize, true)) {
                    int newCount = this.data.func_221476_a(slotId) - 1;
                    this.data.func_221477_a(slotId, newCount);
                    if (newCount == 0) {
                        slot.func_75215_d(ItemStack.field_190927_a);
                    }
                }
                return ItemStack.field_190927_a;
            }
            if (clickTypeIn == ClickType.THROW) {
                this.setSwapIndex(-1, -1);
                ItemStack stack = playerInventory.func_70445_o();
                if (stack.func_190926_b()) {
                    Slot slot = this.func_75139_a(slotId);
                    ItemStack stackInSlot = slot.func_75211_c();
                    if (!stackInSlot.func_190926_b()) {
                        int count = this.data.func_221476_a(slotId);
                        int stackSize = dragType == 1 ? stackInSlot.func_77976_d() : 1;
                        int dropSize = IntUtil.minUnsigned(stackSize, count);
                        ItemStack dropStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)dropSize);
                        player.func_71019_a(dropStack, false);
                        int newCount = count - dropSize;
                        this.data.func_221477_a(slotId, newCount);
                        if (newCount == 0) {
                            slot.func_75215_d(ItemStack.field_190927_a);
                        }
                    }
                    return ItemStack.field_190927_a;
                }
            } else {
                if (clickTypeIn == ClickType.QUICK_MOVE) {
                    this.setSwapIndex(-1, -1);
                    if (dragType == 2) {
                        ItemStack stackInSlot = this.func_75139_a(slotId).func_75211_c().func_77946_l();
                        if (!stackInSlot.func_190926_b()) {
                            for (int i = 0; i < this.chestInventory.func_70302_i_(); ++i) {
                                ItemStack stackInPlayer = this.func_75139_a(i).func_75211_c();
                                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackInPlayer)) continue;
                                while (!this.func_82846_b(player, i).func_190926_b()) {
                                }
                            }
                        }
                        return ItemStack.field_190927_a;
                    }
                    this.func_82846_b(player, slotId);
                    return ItemStack.field_190927_a;
                }
                if (clickTypeIn == ClickType.CLONE) {
                    this.sortInventory(dragType);
                    return ItemStack.field_190927_a;
                }
                if (clickTypeIn == ClickType.SWAP || clickTypeIn == ClickType.PICKUP_ALL || clickTypeIn == ClickType.QUICK_CRAFT) {
                    this.setSwapIndex(-1, -1);
                    return ItemStack.field_190927_a;
                }
            }
        } else if (slotId >= this.chestInventory.func_70302_i_() && slotId < this.totalSlotSize) {
            this.setSwapIndex(-1, -1);
            if (clickTypeIn == ClickType.PICKUP) {
                ItemStack copy;
                ItemStack stackInSlot;
                if (dragType == 3 && !(stackInSlot = this.func_75139_a(slotId).func_75211_c()).func_190926_b() && this.func_75135_a(copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)1), 0, this.chestInventory.func_70302_i_(), false)) {
                    stackInSlot.func_190918_g(1);
                }
            } else if (clickTypeIn == ClickType.QUICK_MOVE && dragType == 2) {
                ItemStack stackInSlot = this.func_75139_a(slotId).func_75211_c().func_77946_l();
                if (!stackInSlot.func_190926_b()) {
                    for (int i = this.chestInventory.func_70302_i_(); i < this.totalSlotSize; ++i) {
                        ItemStack stackInPlayer = this.func_75139_a(i).func_75211_c();
                        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackInPlayer)) continue;
                        this.func_82846_b(player, i);
                    }
                }
                return ItemStack.field_190927_a;
            }
        } else {
            this.setSwapIndex(-1, -1);
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }
}

