/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.tileentity;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.capability.logic.MultiPageLogic;
import net.eidee.minecraft.terrible_chest.capability.logic.TerribleChestItemSorters;
import net.eidee.minecraft.terrible_chest.capability.logic.TerribleChestItemsLogic;
import net.eidee.minecraft.terrible_chest.inventory.container.MultiPageContainer;
import net.eidee.minecraft.terrible_chest.tileentity.TerribleChestTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IIntArray;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MultiPageTileEntity
extends TerribleChestTileEntity<MultiPageLogic, MultiPageTileEntity> {
    public static final int DATA_PAGE = 27;
    public static final int DATA_MAX_PAGE = 28;
    public static final int DATA_SIZE = 29;
    private int page;

    @Override
    protected MultiPageTileEntity getSelf() {
        return this;
    }

    @Override
    protected MultiPageLogic castLogic(TerribleChestItemsLogic logic) {
        return (MultiPageLogic)logic;
    }

    @Override
    protected TerribleChestTileEntity.TerribleChestInventoryWrapper.Factory<MultiPageLogic, MultiPageTileEntity> getInventoryWrapperFactory() {
        return Inventory::new;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        TerribleChestTileEntity.TerribleChestInventoryWrapper inventory = (TerribleChestTileEntity.TerribleChestInventoryWrapper)this.createInventoryWrapper().orElseThrow(() -> new IllegalStateException("\u30c6\u30ea\u30d6\u30eb\u30c1\u30a7\u30b9\u30c8\u306e\u30a4\u30f3\u30d9\u30f3\u30c8\u30ea\u30e9\u30c3\u30d1\u30fc\u4f5c\u6210\u306b\u5931\u6557"));
        return new MultiPageContainer(id, playerInventory, inventory, inventory.getData());
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.page = compound.func_74762_e("Page");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Page", this.page);
        return compound;
    }

    private static class Inventory
    extends TerribleChestTileEntity.TerribleChestInventoryWrapper<MultiPageLogic, MultiPageTileEntity> {
        private IIntArray data = new IIntArray(){

            public int func_221476_a(int index) {
                if (index >= 0 && index < this.func_70302_i_()) {
                    return ((MultiPageLogic)logic).getItemCount(this.getOffset() + index);
                }
                if (index == 27) {
                    return ((MultiPageTileEntity)tileEntity).page;
                }
                if (index == 28) {
                    return ((MultiPageLogic)logic).getMaxPage();
                }
                return 0;
            }

            public void func_221477_a(int index, int value) {
                if (index >= 0 && index < this.func_70302_i_()) {
                    ((MultiPageLogic)logic).setItemCount(this.getOffset() + index, value);
                } else if (index == 27) {
                    ((MultiPageTileEntity)tileEntity).page = value;
                } else if (index == 28) {
                    ((MultiPageLogic)logic).unlockMaxPage();
                }
            }

            public int func_221478_a() {
                return 29;
            }
        };

        Inventory(MultiPageTileEntity tileEntity, MultiPageLogic logic) {
            super(tileEntity, logic);
        }

        private int getOffset() {
            return ((MultiPageTileEntity)this.tileEntity).page * this.func_70302_i_();
        }

        @Override
        protected IIntArray getData() {
            return this.data;
        }

        @Override
        public void sort(int sortType) {
            int offset = this.getOffset();
            if (sortType == 1) {
                ((MultiPageLogic)this.logic).sort(TerribleChestItemSorters.DEFAULT_2, offset, offset + this.func_70302_i_());
            } else if (sortType == 2) {
                ((MultiPageLogic)this.logic).sort(TerribleChestItemSorters.DEFAULT_3, offset, offset + this.func_70302_i_());
            } else {
                ((MultiPageLogic)this.logic).sort(TerribleChestItemSorters.DEFAULT_1, offset, offset + this.func_70302_i_());
            }
        }

        @Override
        public int func_70302_i_() {
            return 27;
        }

        @Override
        public boolean func_191420_l() {
            int offset = this.getOffset();
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.inventory.func_70301_a(offset + i).func_190926_b()) continue;
                return false;
            }
            return true;
        }

        @Override
        public ItemStack func_70301_a(int index) {
            return this.inventory.func_70301_a(this.getOffset() + index);
        }

        @Override
        public ItemStack func_70298_a(int index, int count) {
            return this.inventory.func_70298_a(this.getOffset() + index, count);
        }

        @Override
        public ItemStack func_70304_b(int index) {
            return this.inventory.func_70304_b(this.getOffset() + index);
        }

        @Override
        public void func_70299_a(int index, ItemStack stack) {
            this.inventory.func_70299_a(this.getOffset() + index, stack);
        }

        @Override
        public void func_174888_l() {
            int offset = this.getOffset();
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.inventory.func_70304_b(offset + i);
            }
        }
    }
}

