/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.capability.logic;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.capability.TerribleChestItem;
import net.eidee.minecraft.terrible_chest.capability.logic.TerribleChestItemsLogic;
import net.eidee.minecraft.terrible_chest.config.Config;
import net.minecraft.nbt.CompoundNBT;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MultiPageLogic
extends TerribleChestItemsLogic {
    private int maxPage = 1;

    public MultiPageLogic(Int2ObjectMap<TerribleChestItem> items) {
        super(items);
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public void unlockMaxPage() {
        this.maxPage = Math.min(this.maxPage + 1, (Integer)Config.COMMON.maxPageLimit.get());
    }

    @Override
    protected int getInventorySize() {
        return this.maxPage * 27;
    }

    @Override
    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("MaxPage", this.maxPage);
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        super.readFromNBT(nbt);
        this.maxPage = Math.max(nbt.func_74762_e("MaxPage"), (Integer)Config.COMMON.resetMaxPage.get());
    }
}

