/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.inventory;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemHandler
implements IItemHandler {
    private IInventory inventory;

    public ItemHandler(IInventory inventory) {
        this.inventory = inventory;
    }

    public int getSlots() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.inventory.func_70301_a(slot);
        int slotLimit = this.getSlotLimit(slot);
        if (!stackInSlot.func_190926_b()) {
            int count = stackInSlot.func_190916_E();
            if (count >= slotLimit) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.inventory.func_94041_b(slot, stack)) {
                return stack;
            }
            int m = slotLimit - count;
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(count);
                    this.inventory.func_70299_a(slot, copy);
                    this.inventory.func_70296_d();
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(count);
                this.inventory.func_70299_a(slot, copy);
                this.inventory.func_70296_d();
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!this.inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int m = slotLimit;
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.inventory.func_70299_a(slot, stack.func_77979_a(m));
                this.inventory.func_70296_d();
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!simulate) {
            this.inventory.func_70299_a(slot, stack);
            this.inventory.func_70296_d();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.inventory.func_70301_a(slot);
        if (stackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            if (stackInSlot.func_190916_E() < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.func_190916_E(), amount);
        ItemStack decrStackSize = this.inventory.func_70298_a(slot, m);
        this.inventory.func_70296_d();
        return decrStackSize;
    }

    public int getSlotLimit(int slot) {
        return this.inventory.func_70297_j_();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }
}

