/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.tileentity;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.capability.Capabilities;
import net.eidee.minecraft.terrible_chest.capability.TerribleChestItemsCapability;
import net.eidee.minecraft.terrible_chest.capability.logic.TerribleChestItemSorters;
import net.eidee.minecraft.terrible_chest.capability.logic.TerribleChestItemsLogic;
import net.eidee.minecraft.terrible_chest.inventory.ItemHandler;
import net.eidee.minecraft.terrible_chest.tileentity.TileEntityTypes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TerribleChestTileEntity<LOGIC extends TerribleChestItemsLogic, SELF extends TerribleChestTileEntity<LOGIC, SELF>>
extends TileEntity
implements INamedContainerProvider {
    protected UUID ownerId;

    public TerribleChestTileEntity() {
        super(TileEntityTypes.TERRIBLE_CHEST);
    }

    protected abstract SELF getSelf();

    protected abstract LOGIC castLogic(TerribleChestItemsLogic var1);

    protected abstract TerribleChestInventoryWrapper.Factory<LOGIC, SELF> getInventoryWrapperFactory();

    protected LazyOptional<TerribleChestInventoryWrapper<LOGIC, SELF>> createInventoryWrapper() {
        World world = Objects.requireNonNull(this.func_145831_w());
        PlayerEntity owner = world.func_217371_b(this.ownerId);
        if (owner != null) {
            return owner.getCapability(Capabilities.TERRIBLE_CHEST).map(TerribleChestItemsCapability::getLogic).map(this::castLogic).map(x -> this.getInventoryWrapperFactory().create(this.getSelf(), (TerribleChestItemsLogic)x));
        }
        return LazyOptional.empty();
    }

    protected boolean isUsableByPlayer(PlayerEntity player) {
        BlockPos pos;
        World world = Objects.requireNonNull(this.func_145831_w());
        if (world.func_175625_s(pos = this.func_174877_v()) != this || !Objects.equals(player.func_110124_au(), this.ownerId)) {
            return false;
        }
        return player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    public void setOwnerId(UUID ownerId) {
        this.ownerId = ownerId;
    }

    public boolean isOwner(PlayerEntity player) {
        return Objects.equals(this.ownerId, player.func_110124_au());
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.terrible_chest.terrible_chest", new Object[0]);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.ownerId = compound.func_186857_a("OwnerId");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.ownerId != null) {
            compound.func_186854_a("OwnerId", this.ownerId);
        }
        return compound;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        World world;
        PlayerEntity owner;
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (owner = (world = Objects.requireNonNull(this.func_145831_w())).func_217371_b(this.ownerId)) != null) {
            return this.createInventoryWrapper().map(ItemHandler::new).cast();
        }
        return super.getCapability(cap, side);
    }

    public static abstract class TerribleChestInventoryWrapper<LOGIC extends TerribleChestItemsLogic, TE extends TerribleChestTileEntity<LOGIC, TE>>
    implements IInventory {
        protected final TE tileEntity;
        protected final LOGIC logic;
        protected final IInventory inventory;

        public TerribleChestInventoryWrapper(TE tileEntity, LOGIC logic) {
            this.tileEntity = tileEntity;
            this.logic = logic;
            this.inventory = ((TerribleChestItemsLogic)logic).createInventory();
        }

        protected abstract IIntArray getData();

        public void swap(int index1, int index2) {
            if (index1 >= 0 && index2 >= 0) {
                ((TerribleChestItemsLogic)this.logic).swap(index1, index2);
            }
        }

        public void sort(int sortType) {
            if (sortType == 1) {
                ((TerribleChestItemsLogic)this.logic).sort(TerribleChestItemSorters.DEFAULT_2, 0, this.func_70302_i_());
            } else if (sortType == 2) {
                ((TerribleChestItemsLogic)this.logic).sort(TerribleChestItemSorters.DEFAULT_3, 0, this.func_70302_i_());
            } else {
                ((TerribleChestItemsLogic)this.logic).sort(TerribleChestItemSorters.DEFAULT_1, 0, this.func_70302_i_());
            }
        }

        public int func_70302_i_() {
            return this.inventory.func_70302_i_();
        }

        public boolean func_191420_l() {
            return this.inventory.func_191420_l();
        }

        public ItemStack func_70301_a(int index) {
            return this.inventory.func_70301_a(index);
        }

        public ItemStack func_70298_a(int index, int count) {
            return this.inventory.func_70298_a(index, count);
        }

        public ItemStack func_70304_b(int index) {
            return this.inventory.func_70304_b(index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.inventory.func_70299_a(index, stack);
        }

        public void func_70296_d() {
            this.inventory.func_70296_d();
        }

        public void func_174888_l() {
            this.inventory.func_174888_l();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return ((TerribleChestTileEntity)((Object)this.tileEntity)).isUsableByPlayer(player);
        }

        public int func_70297_j_() {
            return this.inventory.func_70297_j_();
        }

        public static interface Factory<LOGIC extends TerribleChestItemsLogic, TE extends TerribleChestTileEntity<LOGIC, TE>> {
            public TerribleChestInventoryWrapper<LOGIC, TE> create(TE var1, LOGIC var2);
        }
    }
}

