/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.block;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.tileentity.TerribleChestTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TerribleChestBlock
extends Block
implements IWaterLoggable {
    private static final ITextComponent MESSAGE_AUTH_ERROR = new TranslationTextComponent("message.terrible_chest.auth_error");
    static final VoxelShape TERRIBLE_CHEST_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0), Block.func_208617_a((double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0, (double)12.0), Block.func_208617_a((double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0), Block.func_208617_a((double)12.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0), Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)4.0), Block.func_208617_a((double)4.0, (double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0), Block.func_208617_a((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0, (double)16.0), Block.func_208617_a((double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0)});
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public TerribleChestBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return TERRIBLE_CHEST_SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TerribleChestTileEntity();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TerribleChestTileEntity) {
            TerribleChestTileEntity chestTileEntity = (TerribleChestTileEntity)tileentity;
            if (placer instanceof PlayerEntity) {
                chestTileEntity.setOwnerId(placer.func_110124_au());
            }
        }
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        return tileEntity instanceof INamedContainerProvider ? (INamedContainerProvider)tileEntity : null;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TerribleChestTileEntity) {
            if (((TerribleChestTileEntity)tileEntity).isOwner(player)) {
                player.func_213829_a(state.func_215699_b(worldIn, pos));
            } else {
                player.func_145747_a(MESSAGE_AUTH_ERROR, Util.field_240973_b_);
            }
        }
        return ActionResultType.CONSUME;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockState state = super.func_196258_a(context);
        return state != null ? (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a)) : null;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

