/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.block.TerribleChestBlock;
import net.eidee.minecraft.terrible_chest.item.ItemStackContainer;
import net.eidee.minecraft.terrible_chest.tileentity.TerribleChestTileEntity2;
import net.eidee.minecraft.terrible_chest.util.ItemStackContainerUtil;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TerribleChestBlock2
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public TerribleChestBlock2(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT compound = stack.func_179543_a("BlockEntityTag");
        if (compound != null && compound.func_150297_b("Items", 9)) {
            Int2ObjectMap<ItemStackContainer> containers = ItemStackContainerUtil.newContainers();
            ItemStackContainerUtil.loadAllItems(compound, containers);
            int i = 0;
            int j = 0;
            for (ItemStackContainer next : containers.values()) {
                if (next.isEmpty()) continue;
                ++j;
                if (i > 4) continue;
                ++i;
                IFormattableTextComponent textComponent = next.getStack().func_200301_q().func_230532_e_();
                textComponent.func_240702_b_(" x").func_240702_b_(String.format("%,d", next.getCount()));
                tooltip.add((ITextComponent)textComponent);
            }
            if (j - i > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("container.shulkerBox.more", new Object[]{j - i}).func_240699_a_(TextFormatting.ITALIC));
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return TerribleChestBlock.TERRIBLE_CHEST_SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TerribleChestTileEntity2();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TerribleChestTileEntity2) {
            TerribleChestTileEntity2 chestTileEntity = (TerribleChestTileEntity2)tileentity;
            if (stack.func_82837_s()) {
                chestTileEntity.func_213903_a(stack.func_200301_q());
            }
        }
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        return tileEntity instanceof INamedContainerProvider ? (INamedContainerProvider)tileEntity : null;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        player.func_213829_a(state.func_215699_b(worldIn, pos));
        return ActionResultType.CONSUME;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileEntity;
        if (!worldIn.func_201670_d() && player.func_184812_l_() && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && (tileEntity = worldIn.func_175625_s(pos)) instanceof TerribleChestTileEntity2) {
            TerribleChestTileEntity2 chestTileEntity = (TerribleChestTileEntity2)tileEntity;
            ItemStack stack = new ItemStack((IItemProvider)this);
            CompoundNBT compound = chestTileEntity.saveToNbt(new CompoundNBT());
            if (!compound.isEmpty()) {
                stack.func_77983_a("BlockEntityTag", (INBT)compound);
            }
            if (chestTileEntity.func_145818_k_()) {
                stack.func_200302_a(chestTileEntity.func_200201_e());
            }
            TerribleChestBlock2.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockState state = super.func_196258_a(context);
        return state != null ? (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a)) : null;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

