/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.capability;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.capability.Capabilities;
import net.eidee.minecraft.terrible_chest.item.ItemStackContainer;
import net.eidee.minecraft.terrible_chest.settings.Config;
import net.eidee.minecraft.terrible_chest.util.ItemStackContainerUtil;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TerribleChestCapability
implements INBTSerializable<CompoundNBT> {
    public static final ResourceLocation REGISTRY_KEY = new ResourceLocation("terrible_chest", "terrible_chest");
    private Int2ObjectMap<ItemStackContainer> containers = ItemStackContainerUtil.newContainers();
    private int maxPage = 1;

    public Int2ObjectMap<ItemStackContainer> getContainers() {
        return this.containers;
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public void setMaxPage(int maxPage) {
        this.maxPage = maxPage;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ItemStackContainerUtil.saveAllItems(nbt, this.containers);
        nbt.func_74768_a("MaxPage", this.maxPage);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.containers.clear();
        ItemStackContainerUtil.loadAllItems(nbt, this.containers);
        this.maxPage = Math.max(nbt.func_74762_e("MaxPage"), (Integer)Config.COMMON.resetMaxPage.get());
    }

    public static Capability.IStorage<TerribleChestCapability> storage() {
        return new Capability.IStorage<TerribleChestCapability>(){

            public INBT writeNBT(Capability<TerribleChestCapability> capability, TerribleChestCapability instance, Direction side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<TerribleChestCapability> capability, TerribleChestCapability instance, Direction side, INBT nbt) {
                if (nbt instanceof CompoundNBT) {
                    instance.deserializeNBT((CompoundNBT)nbt);
                }
            }
        };
    }

    public static ICapabilitySerializable<CompoundNBT> provider() {
        final Capability<TerribleChestCapability> _cap = Capabilities.TERRIBLE_CHEST;
        final TerribleChestCapability instance = (TerribleChestCapability)_cap.getDefaultInstance();
        return new ICapabilitySerializable<CompoundNBT>(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return _cap.orEmpty(cap, LazyOptional.of(instance == null ? null : () -> instance));
            }

            public CompoundNBT serializeNBT() {
                INBT inbt = _cap.writeNBT((Object)instance, null);
                return inbt instanceof CompoundNBT ? (CompoundNBT)inbt : new CompoundNBT();
            }

            public void deserializeNBT(CompoundNBT nbt) {
                _cap.readNBT((Object)instance, null, (INBT)nbt);
            }
        };
    }
}

