/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.inventory.container.TerribleChestContainer;
import net.eidee.minecraft.terrible_chest.network.Networks;
import net.eidee.minecraft.terrible_chest.network.message.gui.ChangePage;
import net.eidee.minecraft.terrible_chest.network.message.gui.UnlockMaxPage;
import net.eidee.minecraft.terrible_chest.settings.Config;
import net.eidee.minecraft.terrible_chest.settings.KeyBindings;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public abstract class TerribleChestScreen
extends ContainerScreen<TerribleChestContainer> {
    private static final ResourceLocation MULTI_PAGE_TEXTURE = new ResourceLocation("terrible_chest", "textures/gui/container/terrible_chest_multi_page.png");
    private static final ResourceLocation SINGLE_PAGE_TEXTURE = new ResourceLocation("terrible_chest", "textures/gui/container/terrible_chest_single_page.png");
    private static final KeyBinding[] SORT_KEYS = new KeyBinding[]{KeyBindings.SORT_0, KeyBindings.SORT_1, KeyBindings.SORT_2, KeyBindings.SORT_3, KeyBindings.SORT_4, KeyBindings.SORT_5, KeyBindings.SORT_6, KeyBindings.SORT_7, KeyBindings.SORT_8, KeyBindings.SORT_9};

    private TerribleChestScreen(TerribleChestContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
    }

    public static TerribleChestScreen createScreen(TerribleChestContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        return (Boolean)Config.COMMON.useSinglePageMode.get() != false ? new SinglePage(screenContainer, inv, titleIn) : new MultiPage(screenContainer, inv, titleIn);
    }

    protected void func_184098_a(@Nullable Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (type == ClickType.CLONE) {
            super.func_184098_a(null, slotId, 1, type);
            return;
        }
        if (slotIn != null) {
            if (type == ClickType.PICKUP) {
                if (TerribleChestScreen.func_231174_t_()) {
                    if (Objects.equals(slotIn.field_75224_c, ((TerribleChestContainer)this.field_147002_h).getChestInventory())) {
                        super.func_184098_a(slotIn, slotId, 2, type);
                        return;
                    }
                } else if (TerribleChestScreen.func_231172_r_() && (Objects.equals(slotIn.field_75224_c, ((TerribleChestContainer)this.field_147002_h).getChestInventory()) || Objects.equals(slotIn.field_75224_c, ((TerribleChestContainer)this.field_147002_h).getPlayerInventory()))) {
                    super.func_184098_a(slotIn, slotId, 3, type);
                    return;
                }
            } else if (type == ClickType.QUICK_MOVE && (Objects.equals(slotIn.field_75224_c, ((TerribleChestContainer)this.field_147002_h).getChestInventory()) || Objects.equals(slotIn.field_75224_c, ((TerribleChestContainer)this.field_147002_h).getPlayerInventory())) && TerribleChestScreen.func_231172_r_()) {
                super.func_184098_a(slotIn, slotId, 2, type);
                return;
            }
        }
        super.func_184098_a(slotIn, slotId, mouseButton, type);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        Slot slot;
        int index = ((TerribleChestContainer)this.field_147002_h).getSwapIndex();
        Slot slot2 = slot = index >= 0 && index < ((TerribleChestContainer)this.field_147002_h).field_75151_b.size() ? ((TerribleChestContainer)this.field_147002_h).func_75139_a(index) : null;
        if (slot != null && Objects.equals(slot.field_75224_c, ((TerribleChestContainer)this.field_147002_h).getChestInventory())) {
            RenderSystem.disableDepthTest();
            int xPos = this.field_147003_i + slot.field_75223_e;
            int yPos = this.field_147009_r + slot.field_75221_f;
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_238468_a_(matrixStack, xPos, yPos, xPos + 16, yPos + 16, -2130771968, -2130771968);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    public List<ITextComponent> func_231151_a_(ItemStack itemStack) {
        List tooltip = super.func_231151_a_(itemStack);
        Slot slot = this.getSlotUnderMouse();
        if (slot != null && Objects.equals(slot.field_75224_c, ((TerribleChestContainer)this.field_147002_h).getChestInventory())) {
            long count = ((TerribleChestContainer)this.field_147002_h).getItemCount(slot.getSlotIndex());
            String text = I18n.func_135052_a((String)"gui.terrible_chest.terrible_chest.count", (Object[])new Object[]{count});
            tooltip.add(1, new StringTextComponent(text));
        }
        return tooltip;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        for (int i = 0; i < SORT_KEYS.length; ++i) {
            if (!SORT_KEYS[i].func_197976_a(keyCode, scanCode)) continue;
            super.func_184098_a(null, 0, i, ClickType.CLONE);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    private static class SinglePage
    extends TerribleChestScreen {
        public SinglePage(TerribleChestContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
            super(screenContainer, inv, titleIn);
            this.field_146999_f = 356;
            this.field_147000_g = 238;
            this.field_238744_r_ = 98;
            this.field_238745_s_ = this.field_147000_g - 93;
        }

        @Override
        protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(SINGLE_PAGE_TEXTURE);
            SinglePage.func_238464_a_((MatrixStack)matrixStack, (int)this.field_147003_i, (int)this.field_147009_r, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)256, (int)512);
            super.func_230450_a_(matrixStack, partialTicks, x, y);
        }
    }

    private static class MultiPage
    extends TerribleChestScreen {
        private final int inventoryRows;

        public MultiPage(TerribleChestContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
            super(screenContainer, inv, titleIn);
            this.inventoryRows = (Integer)Config.COMMON.inventoryRows.get();
            this.field_147000_g = 132 + this.inventoryRows * 18;
            this.field_238745_s_ = this.field_147000_g - 93;
        }

        protected void func_231160_c_() {
            super.func_231160_c_();
            this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 121, this.field_147009_r + 6, 11, 11, 187, 118, 11, MULTI_PAGE_TEXTURE, button -> Networks.getChannel().sendToServer((Object)new ChangePage(((TerribleChestContainer)this.field_147002_h).getCurrentPage() - 10))));
            this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 134, this.field_147009_r + 6, 7, 11, 183, 96, 11, MULTI_PAGE_TEXTURE, button -> Networks.getChannel().sendToServer((Object)new ChangePage(((TerribleChestContainer)this.field_147002_h).getCurrentPage() - 1))));
            this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 149, this.field_147009_r + 6, 7, 11, 176, 96, 11, MULTI_PAGE_TEXTURE, button -> Networks.getChannel().sendToServer((Object)new ChangePage(((TerribleChestContainer)this.field_147002_h).getCurrentPage() + 1))));
            this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 158, this.field_147009_r + 6, 11, 11, 176, 118, 11, MULTI_PAGE_TEXTURE, button -> Networks.getChannel().sendToServer((Object)new ChangePage(((TerribleChestContainer)this.field_147002_h).getCurrentPage() + 10))));
            this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 181, this.field_147009_r + 8, 20, 20, 176, 56, 20, MULTI_PAGE_TEXTURE, button -> Networks.getChannel().sendToServer((Object)UnlockMaxPage.INSTANCE)));
        }

        @Override
        protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(MULTI_PAGE_TEXTURE);
            this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.inventoryRows * 18 + 35);
            this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r + this.inventoryRows * 18 + 35, 0, 143, this.field_146999_f, 97);
            this.func_238474_b_(matrixStack, this.field_147003_i + this.field_146999_f, this.field_147009_r + 3, 176, 0, 33, 56);
            super.func_230450_a_(matrixStack, partialTicks, x, y);
        }

        protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
            super.func_230451_b_(matrixStack, x, y);
            String page = ((TerribleChestContainer)this.field_147002_h).getCurrentPage() + 1 + " / ";
            int pageWidth = this.field_230712_o_.func_78256_a(page);
            String maxPage = Integer.toString(((TerribleChestContainer)this.field_147002_h).getMaxPage());
            int maxPageWidth = this.field_230712_o_.func_78256_a(maxPage);
            this.field_230712_o_.func_238421_b_(matrixStack, page, 169.0f - (float)maxPageWidth - (float)pageWidth, 24.0f, 0x404040);
            this.field_230712_o_.func_238421_b_(matrixStack, maxPage, 169.0f - (float)maxPageWidth, 24.0f, 0x404040);
        }
    }
}

