/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.inventory.container;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Comparator;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.inventory.TerribleChestInventory;
import net.eidee.minecraft.terrible_chest.inventory.container.ContainerTypes;
import net.eidee.minecraft.terrible_chest.item.ItemStackContainer;
import net.eidee.minecraft.terrible_chest.item.Items;
import net.eidee.minecraft.terrible_chest.item.TerribleChestItemHandler;
import net.eidee.minecraft.terrible_chest.settings.Config;
import net.eidee.minecraft.terrible_chest.util.TerribleChestItemSorters;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TerribleChestContainer
extends Container {
    public static final int DATA_MAX_PAGE = 0;
    public static final int DATA_CURRENT_PAGE = 1;
    public static final int TYPE_LEFT_CLICK = 0;
    public static final int TYPE_RIGHT_CLICK = 1;
    public static final int TYPE_SWAP = 2;
    public static final int TYPE_ONE_BY_ONE = 3;
    public static final int TYPE_THROW_MAX_STACK = 1;
    public static final int TYPE_MOVE_THE_SAME = 2;
    private final PlayerInventory playerInventory;
    private final TerribleChestInventory chestInventory;
    private final IInventory unlockInventory;
    private final IIntArray chestData;
    private final IIntArray itemCounts;
    private final int mainInventorySize;
    private int swapIndex;

    public TerribleChestContainer(int id, PlayerInventory playerInventory, TerribleChestInventory chestInventory, final IIntArray chestData) {
        super(ContainerTypes.TERRIBLE_CHEST, id);
        this.playerInventory = playerInventory;
        this.chestInventory = chestInventory;
        this.unlockInventory = new Inventory(1);
        this.chestData = chestData;
        this.itemCounts = chestInventory.getItemCountAccessor();
        this.mainInventorySize = playerInventory.field_70462_a.size() + chestInventory.func_70302_i_();
        this.swapIndex = -1;
        if (((Boolean)Config.COMMON.useSinglePageMode.get()).booleanValue()) {
            this.slotInitializeSinglePage();
        } else {
            this.slotInitializeMultiPage();
        }
        this.func_216961_a(this.chestData);
        int i = 0;
        while (i < this.itemCounts.func_221478_a()) {
            final int index = i++;
            this.func_216958_a(new IntReferenceHolder(){
                private int lastKnownPage = -1;

                public int func_221495_b() {
                    return TerribleChestContainer.this.itemCounts.func_221476_a(index);
                }

                public void func_221494_a(int value) {
                    TerribleChestContainer.this.itemCounts.func_221477_a(index, value);
                }

                public boolean func_221496_c() {
                    if (super.func_221496_c()) {
                        return true;
                    }
                    int page = chestData.func_221476_a(1);
                    boolean flag = page != this.lastKnownPage;
                    this.lastKnownPage = page;
                    return flag;
                }
            });
        }
    }

    public static TerribleChestContainer createContainer(int id, PlayerInventory playerInventory) {
        int slots = 133;
        if (!((Boolean)Config.COMMON.useSinglePageMode.get()).booleanValue()) {
            slots = (Integer)Config.COMMON.inventoryRows.get() * 9;
        }
        return new TerribleChestContainer(id, playerInventory, TerribleChestInventory.dummy(slots), (IIntArray)new IntArray(2));
    }

    private void slotInitializeMultiPage() {
        int j;
        int i;
        int rows = (Integer)Config.COMMON.inventoryRows.get();
        int offset = (rows - 4) * 18;
        for (i = 0; i < rows; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.chestInventory, j + i * 9, 8 + j * 18, 36 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, j + i * 9 + 9, 8 + j * 18, 122 + i * 18 + offset));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, i, 8 + i * 18, 180 + offset));
        }
        this.func_75146_a(new Slot(this.unlockInventory, 0, 183, 35));
    }

    private void slotInitializeSinglePage() {
        int j;
        int i;
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 19; ++j) {
                this.func_75146_a(new Slot((IInventory)this.chestInventory, j + i * 19, 8 + j * 18, 17 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, j + i * 9 + 9, 98 + j * 18, 156 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, i, 98 + i * 18, 214));
        }
    }

    private void swap(int index1, int index2) {
        TerribleChestItemHandler itemHandler = this.chestInventory.getItemHandler();
        ItemStackContainer container1 = itemHandler.removeContainerInSlot(index1);
        ItemStackContainer container2 = itemHandler.removeContainerInSlot(index2);
        if (!container2.isEmpty()) {
            itemHandler.setContainerInSlot(index1, container2);
        }
        if (!container1.isEmpty()) {
            itemHandler.setContainerInSlot(index2, container1);
        }
    }

    private void sort(Comparator<ItemStackContainer> comparator, int index1, int index2) {
        if (index1 >= 0 && index2 >= 0 && index1 < index2) {
            int length;
            TerribleChestItemHandler itemHandler = this.chestInventory.getItemHandler();
            int h = length = index2 - index1;
            boolean loop = false;
            while (h > 1 || loop) {
                if (h > 1) {
                    h = h * 10 / 13;
                }
                loop = false;
                for (int i = 0; i < length - h; ++i) {
                    boolean swap;
                    int j = index1 + i;
                    int k = j + h;
                    ItemStackContainer container1 = itemHandler.getContainerInSlot(j);
                    ItemStackContainer container2 = itemHandler.getContainerInSlot(k);
                    boolean bl = swap = container1.isEmpty() && !container2.isEmpty();
                    if (!container1.isEmpty() && !container2.isEmpty()) {
                        long freeSpace;
                        if (ItemHandlerHelper.canItemStacksStack((ItemStack)container1.getStack(), (ItemStack)container2.getStack()) && (freeSpace = itemHandler.getSlotFreeSpace(j)) > 0L) {
                            long size = Math.min(container2.getCount(), freeSpace);
                            container1.growCount(size);
                            container2.shrinkCount(size);
                            loop = true;
                        }
                        boolean bl2 = swap = comparator.compare(container1, container2) > 0;
                    }
                    if (!swap) continue;
                    this.swap(j, k);
                    loop = true;
                }
            }
        }
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        IntStream stream = IntStream.range(startIndex, endIndex);
        if (reverseDirection) {
            stream = stream.map(i -> endIndex - i + startIndex - 1);
        }
        PrimitiveIterator.OfInt it = stream.filter(i -> i >= 0 && i < this.field_75151_b.size()).iterator();
        boolean result = false;
        IntArrayList emptySlots = new IntArrayList(endIndex - startIndex);
        while (it.hasNext() && !stack.func_190926_b()) {
            int size;
            int index = it.nextInt();
            Slot slot = this.func_75139_a(index);
            ItemStack stackInSlot = slot.func_75211_c();
            if (stackInSlot.func_190926_b()) {
                emptySlots.add(index);
                continue;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) continue;
            if (index < this.chestInventory.func_70302_i_()) {
                long freeSpace = this.chestInventory.getItemHandler().getSlotFreeSpace(index);
                if (freeSpace <= 0L) continue;
                size = (int)Math.min((long)stack.func_190916_E(), freeSpace);
                this.chestInventory.getContainerInSlot(index).growCount(size);
                stack.func_190918_g(size);
                result = true;
                continue;
            }
            int count = stackInSlot.func_190916_E();
            int freeSpace = Math.min(stackInSlot.func_77976_d(), slot.func_75219_a()) - count;
            if (freeSpace <= 0) continue;
            size = Math.min(stack.func_190916_E(), freeSpace);
            stackInSlot.func_190917_f(size);
            stack.func_190918_g(size);
            result = true;
        }
        if (!stack.func_190926_b()) {
            IntListIterator emptiesIt = emptySlots.iterator();
            while (emptiesIt.hasNext()) {
                int emptySlot = emptiesIt.nextInt();
                Slot slot = this.func_75139_a(emptySlot);
                slot.func_75215_d(stack.func_77979_a(slot.func_75219_a()));
                result = true;
                if (!stack.func_190926_b()) continue;
                break;
            }
        }
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMaxPage() {
        return this.chestData.func_221476_a(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCurrentPage() {
        return this.chestData.func_221476_a(1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long getItemCount(int slot) {
        return Integer.toUnsignedLong(this.itemCounts.func_221476_a(slot));
    }

    @OnlyIn(value=Dist.CLIENT)
    public IInventory getPlayerInventory() {
        return this.playerInventory;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IInventory getChestInventory() {
        return this.chestInventory;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSwapIndex() {
        return this.swapIndex;
    }

    public void changePage(int page) {
        int currentPage = this.chestData.func_221476_a(1);
        int maxPage = this.chestData.func_221476_a(0);
        int nextPage = MathHelper.func_76125_a((int)page, (int)0, (int)(maxPage - 1));
        if (nextPage != currentPage) {
            this.chestData.func_221477_a(1, nextPage);
        }
    }

    public void unlockMaxPage() {
        int maxPage;
        int nextMaxPage;
        ItemStack stack = this.unlockInventory.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.DIAMOND_SPHERE && (nextMaxPage = MathHelper.func_76125_a((int)((maxPage = this.chestData.func_221476_a(0)) + 1), (int)0, (int)((Integer)Config.COMMON.maxPageLimit.get()))) > maxPage) {
            stack.func_190918_g(1);
            this.chestData.func_221477_a(0, nextMaxPage);
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.chestInventory.func_70300_a(playerIn);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        ItemStack stack = this.unlockInventory.func_70304_b(0);
        if (!stack.func_190926_b() && !playerIn.func_191521_c(stack)) {
            playerIn.func_71019_a(stack, true);
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        Slot slot;
        Slot slot2 = slot = slotId >= 0 && slotId < this.mainInventorySize ? this.func_75139_a(slotId) : null;
        if (slot == null) {
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        if (slotId < this.chestInventory.func_70302_i_()) {
            int n = this.swapIndex = clickTypeIn == ClickType.PICKUP ? this.swapIndex : -1;
            if (clickTypeIn == ClickType.PICKUP) {
                ItemStack copy;
                ItemStack grabbedStack = this.playerInventory.func_70445_o().func_77946_l();
                ItemStack stackInSlot = slot.func_75211_c();
                if (this.swapIndex != -1) {
                    dragType = 2;
                }
                if (dragType == 0) {
                    if (grabbedStack.func_190926_b()) {
                        if (!stackInSlot.func_190926_b()) {
                            ItemStack result = slot.func_75209_a(stackInSlot.func_77976_d());
                            this.playerInventory.func_70437_b(result);
                            return result;
                        }
                    } else {
                        if (stackInSlot.func_190926_b()) {
                            slot.func_75215_d(grabbedStack);
                            this.playerInventory.func_70437_b(ItemStack.field_190927_a);
                            return ItemStack.field_190927_a;
                        }
                        if (ItemHandlerHelper.canItemStacksStack((ItemStack)grabbedStack, (ItemStack)stackInSlot) && this.func_75135_a(grabbedStack, slotId, slotId + 1, false)) {
                            this.playerInventory.func_70437_b(grabbedStack);
                            return grabbedStack;
                        }
                    }
                } else if (dragType == 1) {
                    if (grabbedStack.func_190926_b()) {
                        if (!stackInSlot.func_190926_b()) {
                            long count = this.chestInventory.getContainerInSlot(slotId).getCount();
                            int size = (int)Math.min(count, (long)stackInSlot.func_77976_d()) / 2;
                            ItemStack result = slot.func_75209_a(size);
                            this.playerInventory.func_70437_b(result);
                            return result;
                        }
                    } else {
                        if (stackInSlot.func_190926_b()) {
                            slot.func_75215_d(grabbedStack.func_77979_a(1));
                            this.playerInventory.func_70437_b(grabbedStack);
                            return grabbedStack;
                        }
                        if (ItemHandlerHelper.canItemStacksStack((ItemStack)grabbedStack, (ItemStack)stackInSlot) && this.chestInventory.getItemHandler().getSlotFreeSpace(slotId) > 0L) {
                            grabbedStack.func_190918_g(1);
                            this.chestInventory.getContainerInSlot(slotId).growCount(1L);
                            this.playerInventory.func_70437_b(grabbedStack);
                            return grabbedStack;
                        }
                    }
                } else if (dragType == 2) {
                    if (this.swapIndex >= 0) {
                        this.swap(this.swapIndex, slotId);
                        this.swapIndex = -1;
                    } else {
                        this.swapIndex = slotId;
                    }
                } else if (dragType == 3 && !stackInSlot.func_190926_b() && this.func_75135_a(copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)1), this.chestInventory.func_70302_i_(), this.mainInventorySize, true)) {
                    this.chestInventory.getContainerInSlot(slotId).shrinkCount(1L);
                    if (this.chestInventory.getContainerInSlot(slotId).isEmpty()) {
                        slot.func_75215_d(ItemStack.field_190927_a);
                    }
                }
            } else if (clickTypeIn == ClickType.THROW) {
                ItemStack stackInSlot;
                ItemStack grabbedStack = this.playerInventory.func_70445_o();
                if (grabbedStack.func_190926_b() && !(stackInSlot = slot.func_75211_c()).func_190926_b()) {
                    ItemStackContainer container = this.chestInventory.getContainerInSlot(slotId);
                    int stackSize = dragType == 1 ? stackInSlot.func_77976_d() : 1;
                    int dropSize = (int)Math.min((long)stackSize, container.getCount());
                    player.func_71019_a(ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)dropSize), false);
                    container.shrinkCount(dropSize);
                    if (container.isEmpty()) {
                        slot.func_75215_d(ItemStack.field_190927_a);
                    }
                }
            } else if (clickTypeIn == ClickType.QUICK_MOVE) {
                if (dragType == 2) {
                    ItemStack stackInSlot = slot.func_75211_c().func_77946_l();
                    if (!stackInSlot.func_190926_b()) {
                        for (int i = 0; i < this.chestInventory.func_70302_i_(); ++i) {
                            ItemStack stackInChest = this.func_75139_a(i).func_75211_c();
                            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackInChest)) continue;
                            while (!this.func_82846_b(player, i).func_190926_b()) {
                            }
                        }
                    }
                } else {
                    this.func_82846_b(player, slotId);
                }
            } else if (clickTypeIn == ClickType.CLONE) {
                Comparator<ItemStackContainer> comparator = TerribleChestItemSorters.DEFAULT_1;
                if (dragType == 2) {
                    comparator = TerribleChestItemSorters.DEFAULT_2;
                } else if (dragType == 3) {
                    comparator = TerribleChestItemSorters.DEFAULT_3;
                }
                this.sort(comparator, 0, this.chestInventory.func_70302_i_());
            }
            return ItemStack.field_190927_a;
        }
        this.swapIndex = -1;
        if (clickTypeIn == ClickType.PICKUP) {
            ItemStack copy;
            ItemStack stackInSlot;
            if (dragType == 3 && !(stackInSlot = slot.func_75211_c()).func_190926_b() && this.func_75135_a(copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)1), 0, this.chestInventory.func_70302_i_(), false)) {
                stackInSlot.func_190918_g(1);
            }
        } else if (clickTypeIn == ClickType.QUICK_MOVE && dragType == 2) {
            ItemStack stackInSlot = slot.func_75211_c().func_77946_l();
            if (!stackInSlot.func_190926_b()) {
                for (int i = this.chestInventory.func_70302_i_(); i < this.mainInventorySize; ++i) {
                    ItemStack stackInPlayer = this.func_75139_a(i).func_75211_c();
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackInPlayer)) continue;
                    this.func_82846_b(player, i);
                }
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot;
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot2 = slot = index >= 0 && index < this.field_75151_b.size() ? (Slot)this.field_75151_b.get(index) : null;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (index < this.chestInventory.func_70302_i_()) {
                ItemStackContainer container = this.chestInventory.getContainerInSlot(index);
                int size = (int)Math.min(container.getCount(), (long)stackInSlot.func_77976_d());
                ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)size);
                if (!this.func_75135_a(copy, this.chestInventory.func_70302_i_(), this.mainInventorySize, true)) {
                    return ItemStack.field_190927_a;
                }
                container.shrinkCount(size - copy.func_190916_E());
                if (container.isEmpty()) {
                    stackInSlot.func_190920_e(0);
                }
            } else if (index < this.mainInventorySize ? !this.func_75135_a(stackInSlot, 0, this.chestInventory.func_70302_i_(), false) : !this.func_75135_a(stackInSlot, this.chestInventory.func_70302_i_(), this.mainInventorySize, true)) {
                return ItemStack.field_190927_a;
            }
            if (stackInSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    public boolean func_94531_b(Slot slotIn) {
        return Objects.equals(slotIn.field_75224_c, this.playerInventory);
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return Objects.equals(slotIn.field_75224_c, this.playerInventory);
    }
}

