/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.item;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemStackContainer {
    public static ItemStackContainer EMPTY = new ItemStackContainer(ItemStack.field_190927_a, 0L);
    private boolean empty;
    private ItemStack stack;
    private long count;

    private ItemStackContainer(ItemStack stack, long count) {
        this.stack = stack;
        this.count = count;
    }

    private ItemStackContainer(CompoundNBT nbt) {
        this.stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Stack"));
        this.count = Integer.toUnsignedLong(nbt.func_74762_e("Count"));
    }

    public static ItemStackContainer create(ItemStack stack, int count) {
        if (stack.func_190926_b() || count == 0) {
            return EMPTY;
        }
        ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        ItemStackContainer container = new ItemStackContainer(copy, count);
        container.updateEmptyState();
        return container;
    }

    public static ItemStackContainer create(ItemStack stack) {
        return ItemStackContainer.create(stack, stack.func_190916_E());
    }

    public static ItemStackContainer read(CompoundNBT nbt) {
        ItemStackContainer container = new ItemStackContainer(nbt);
        container.updateEmptyState();
        return container;
    }

    private void updateEmptyState() {
        this.empty = this.isEmpty();
    }

    public boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        if (this.stack.func_190926_b()) {
            return true;
        }
        return this.count <= 0L;
    }

    public ItemStack getStack() {
        return this.empty ? ItemStack.field_190927_a : this.stack;
    }

    public long getCount() {
        return this.empty ? 0L : this.count;
    }

    public void setCount(long count) {
        this.count = count;
        this.updateEmptyState();
    }

    public void growCount(long count) {
        this.setCount(this.count + count);
    }

    public void shrinkCount(long count) {
        this.growCount(-count);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Stack", (INBT)this.stack.serializeNBT());
        nbt.func_74768_a("Count", (int)this.count);
        return nbt;
    }
}

