/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.item;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.NoSuchElementException;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.capability.Capabilities;
import net.eidee.minecraft.terrible_chest.capability.TerribleChestCapability;
import net.eidee.minecraft.terrible_chest.item.TerribleChestItemHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TerribleBangleItem
extends Item {
    public TerribleBangleItem(Item.Properties properties) {
        super(properties);
    }

    private void moveInventoryItems(IItemHandler src, IItemHandler dest) {
        block0: for (int i = 0; i < src.getSlots(); ++i) {
            ItemStack stackInSlot;
            while (!(stackInSlot = src.getStackInSlot(i)).func_190926_b()) {
                ItemStack stack = src.extractItem(i, stackInSlot.func_77976_d(), false);
                IntArrayList emptySlots = new IntArrayList();
                for (int j = 0; j < dest.getSlots(); ++j) {
                    if (dest.getStackInSlot(j).func_190926_b()) {
                        emptySlots.add(j);
                        continue;
                    }
                    if ((stack = dest.insertItem(j, stack, false)).func_190926_b()) break;
                }
                if (!stack.func_190926_b()) {
                    int emptySlot;
                    IntListIterator it = emptySlots.iterator();
                    while (it.hasNext() && !(stack = dest.insertItem(emptySlot = it.nextInt(), stack, false)).func_190926_b()) {
                    }
                }
                if (stack.func_190926_b()) continue;
                src.insertItem(i, stack, false);
                continue block0;
            }
        }
    }

    private void collectItems(PlayerEntity playerEntity, TileEntity tileEntity) {
        IItemHandler src = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)EmptyHandler.INSTANCE);
        IItemHandler dest = (IItemHandler)playerEntity.getCapability(Capabilities.TERRIBLE_CHEST).map(TerribleChestCapability::getContainers).map(TerribleChestItemHandler::create).orElseThrow(NoSuchElementException::new);
        this.moveInventoryItems(src, dest);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        ItemStack heldItem = playerEntity.func_184586_b(hand);
        BlockRayTraceResult rayTrace = TerribleBangleItem.func_219968_a((World)world, (PlayerEntity)playerEntity, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (rayTrace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)heldItem);
        }
        BlockPos pos = rayTrace.func_216350_a();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            playerEntity.func_184598_c(hand);
            playerEntity.func_184609_a(hand);
            playerEntity.func_184185_a(SoundEvents.field_187909_gi, 0.25f, 1.0f);
            if (!world.func_201670_d()) {
                this.collectItems(playerEntity, tileEntity);
            }
            return ActionResult.func_226248_a_((Object)heldItem);
        }
        return ActionResult.func_226251_d_((Object)heldItem);
    }
}

