/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.item;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.function.IntSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.item.ItemStackContainer;
import net.eidee.minecraft.terrible_chest.settings.Config;
import net.eidee.minecraft.terrible_chest.util.ItemStackContainerUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TerribleChestItemHandler
implements IItemHandlerModifiable {
    public static TerribleChestItemHandler create(final Int2ObjectMap<ItemStackContainer> containers, final IntSupplier offset, final IntSupplier length) {
        return new TerribleChestItemHandler(){

            @Override
            protected Int2ObjectMap<ItemStackContainer> getContainers() {
                return containers;
            }

            @Override
            protected int getOffset() {
                return offset.getAsInt();
            }

            @Override
            public int getSlots() {
                return length.getAsInt();
            }
        };
    }

    public static TerribleChestItemHandler create(final Int2ObjectMap<ItemStackContainer> containers, final int offset, final int length) {
        return new TerribleChestItemHandler(){

            @Override
            protected Int2ObjectMap<ItemStackContainer> getContainers() {
                return containers;
            }

            @Override
            protected int getOffset() {
                return offset;
            }

            @Override
            public int getSlots() {
                return length;
            }
        };
    }

    public static TerribleChestItemHandler create(Int2ObjectMap<ItemStackContainer> containers) {
        IntIterator it = containers.keySet().iterator();
        int slots = -1;
        while (it.hasNext()) {
            slots = Math.max(slots, it.nextInt());
        }
        return TerribleChestItemHandler.create(containers, 0, slots + 1);
    }

    public static TerribleChestItemHandler dummy(final int length) {
        final Int2ObjectMap<ItemStackContainer> containers = ItemStackContainerUtil.newContainers();
        return new TerribleChestItemHandler(){

            @Override
            protected Int2ObjectMap<ItemStackContainer> getContainers() {
                return containers;
            }

            @Override
            protected int getOffset() {
                return 0;
            }

            @Override
            public int getSlots() {
                return length;
            }
        };
    }

    protected abstract Int2ObjectMap<ItemStackContainer> getContainers();

    protected abstract int getOffset();

    public abstract int getSlots();

    public ItemStackContainer getContainerInSlot(int slot) {
        return (ItemStackContainer)this.getContainers().get(this.getOffset() + slot);
    }

    public ItemStackContainer setContainerInSlot(int slot, ItemStackContainer container) {
        return (ItemStackContainer)this.getContainers().put(this.getOffset() + slot, (Object)container);
    }

    public ItemStackContainer removeContainerInSlot(int slot) {
        return (ItemStackContainer)this.getContainers().remove(this.getOffset() + slot);
    }

    public long getSlotLimitLong(int slot) {
        return (Long)Config.COMMON.slotStackLimit.get();
    }

    public long getSlotFreeSpace(int slot) {
        return this.getSlotLimitLong(slot) - this.getContainerInSlot(slot).getCount();
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            this.removeContainerInSlot(slot);
        } else {
            int size = (int)Math.min((long)stack.func_190916_E(), this.getSlotLimitLong(slot));
            this.setContainerInSlot(slot, ItemStackContainer.create(stack, size));
        }
    }

    public ItemStack getStackInSlot(int slot) {
        ItemStackContainer container = this.getContainerInSlot(slot);
        ItemStack stack = container.getStack();
        int size = (int)Math.min(container.getCount(), (long)stack.func_77976_d());
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStackContainer container = this.getContainerInSlot(slot);
        ItemStack stackInSlot = container.getStack();
        long limit = this.getSlotLimitLong(slot);
        if (!container.isEmpty()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            limit -= container.getCount();
        }
        if (limit <= 0L) {
            return stack;
        }
        int toInsert = (int)Math.min((long)stack.func_190916_E(), limit);
        if (!simulate) {
            if (container.isEmpty()) {
                this.setContainerInSlot(slot, ItemStackContainer.create(stack, toInsert));
            } else {
                container.growCount(toInsert);
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - toInsert));
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStackContainer container = this.getContainerInSlot(slot);
        if (container.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = container.getStack();
        long stackCount = container.getCount();
        int toExtract = (int)Math.min(Math.min((long)amount, stackCount), (long)stackInSlot.func_77976_d());
        if (!simulate) {
            if (stackCount > (long)toExtract) {
                container.shrinkCount(toExtract);
            } else {
                this.removeContainerInSlot(slot);
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return (int)Math.min(Integer.MAX_VALUE, this.getSlotLimitLong(slot));
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }
}

