/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.tileentity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.capability.Capabilities;
import net.eidee.minecraft.terrible_chest.capability.TerribleChestCapability;
import net.eidee.minecraft.terrible_chest.inventory.TerribleChestInventory;
import net.eidee.minecraft.terrible_chest.inventory.container.TerribleChestContainer;
import net.eidee.minecraft.terrible_chest.item.ItemStackContainer;
import net.eidee.minecraft.terrible_chest.item.TerribleChestItemHandler;
import net.eidee.minecraft.terrible_chest.settings.Config;
import net.eidee.minecraft.terrible_chest.tileentity.TileEntityTypes;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TerribleChestTileEntity
extends TileEntity
implements INamedContainerProvider {
    static ITextComponent CONTAINER_NAME = new TranslationTextComponent("container.terrible_chest.terrible_chest");
    private UUID ownerId = null;
    private int page = 0;

    public TerribleChestTileEntity() {
        super(TileEntityTypes.TERRIBLE_CHEST);
    }

    private void dataFix(CompoundNBT compound) {
        if (compound.func_74764_b("OwnerIdMost") && compound.func_74764_b("OwnerIdLeast")) {
            UUID uuid = new UUID(compound.func_74763_f("OwnerIdMost"), compound.func_74763_f("OwnerIdLeast"));
            compound.func_186854_a("OwnerId", uuid);
        }
    }

    private TerribleChestItemHandler createItemHandler(Int2ObjectMap<ItemStackContainer> containers) {
        if (((Boolean)Config.COMMON.useSinglePageMode.get()).booleanValue()) {
            return TerribleChestItemHandler.create(containers, 0, 133);
        }
        int slots = (Integer)Config.COMMON.inventoryRows.get() * 9;
        return TerribleChestItemHandler.create(containers, () -> this.page * slots, () -> slots);
    }

    private TerribleChestInventory createInventory(TerribleChestCapability chest) {
        final TerribleChestItemHandler itemHandler = this.createItemHandler(chest.getContainers());
        return new TerribleChestInventory(){

            @Override
            public TerribleChestItemHandler getItemHandler() {
                return itemHandler;
            }

            public void func_70296_d() {
            }

            public boolean func_70300_a(PlayerEntity player) {
                World world = TerribleChestTileEntity.this.func_145831_w();
                BlockPos pos = TerribleChestTileEntity.this.func_174877_v();
                if (world == null || world.func_175625_s(pos) != TerribleChestTileEntity.this) {
                    return false;
                }
                if (!TerribleChestTileEntity.this.isOwner(player)) {
                    return false;
                }
                return !(player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) > 64.0);
            }
        };
    }

    private IIntArray createChestData(final TerribleChestCapability chest) {
        return new IIntArray(){

            public int func_221476_a(int index) {
                if (index == 0) {
                    return chest.getMaxPage();
                }
                if (index == 1) {
                    return TerribleChestTileEntity.this.page;
                }
                return 0;
            }

            public void func_221477_a(int index, int value) {
                if (index == 0) {
                    chest.setMaxPage(value);
                }
                if (index == 1) {
                    TerribleChestTileEntity.this.page = value;
                }
            }

            public int func_221478_a() {
                return 2;
            }
        };
    }

    public void setOwnerId(UUID ownerId) {
        this.ownerId = ownerId;
    }

    public boolean isOwner(PlayerEntity player) {
        return Objects.equals(this.ownerId, player.func_110124_au());
    }

    public ITextComponent func_145748_c_() {
        return CONTAINER_NAME;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        TerribleChestCapability chest = (TerribleChestCapability)playerEntity.getCapability(Capabilities.TERRIBLE_CHEST).orElseThrow(NoSuchElementException::new);
        return new TerribleChestContainer(id, playerInventory, this.createInventory(chest), this.createChestData(chest));
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.dataFix(compound);
        this.ownerId = null;
        if (compound.func_186855_b("OwnerId")) {
            this.ownerId = compound.func_186857_a("OwnerId");
        }
        this.page = compound.func_74762_e("Page");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.ownerId != null) {
            compound.func_186854_a("OwnerId", this.ownerId);
        }
        compound.func_74768_a("Page", this.page);
        return compound;
    }
}

