/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.tileentity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.eidee.minecraft.terrible_chest.inventory.TerribleChestInventory;
import net.eidee.minecraft.terrible_chest.inventory.container.TerribleChestContainer;
import net.eidee.minecraft.terrible_chest.item.ItemStackContainer;
import net.eidee.minecraft.terrible_chest.item.TerribleChestItemHandler;
import net.eidee.minecraft.terrible_chest.settings.Config;
import net.eidee.minecraft.terrible_chest.tileentity.TerribleChestTileEntity;
import net.eidee.minecraft.terrible_chest.tileentity.TileEntityTypes;
import net.eidee.minecraft.terrible_chest.util.ItemStackContainerUtil;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TerribleChestTileEntity2
extends LockableTileEntity
implements INamedContainerProvider,
TerribleChestInventory {
    private final IIntArray chestData = new IIntArray(){

        public int func_221476_a(int index) {
            if (index == 0) {
                return TerribleChestTileEntity2.this.maxPage;
            }
            if (index == 1) {
                return TerribleChestTileEntity2.this.page;
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            if (index == 0) {
                TerribleChestTileEntity2.this.maxPage = value;
            }
            if (index == 1) {
                TerribleChestTileEntity2.this.page = value;
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    private Int2ObjectMap<ItemStackContainer> containers = ItemStackContainerUtil.newContainers();
    private int maxPage = 1;
    private int page = 0;

    public TerribleChestTileEntity2() {
        super(TileEntityTypes.TERRIBLE_CHEST_2);
    }

    public void loadFromNbt(CompoundNBT compound) {
        this.containers.clear();
        ItemStackContainerUtil.loadAllItems(compound, this.containers);
        this.maxPage = compound.func_74762_e("MaxPage");
        this.page = compound.func_74762_e("Page");
    }

    public CompoundNBT saveToNbt(CompoundNBT compound) {
        ItemStackContainerUtil.saveAllItems(compound, this.containers);
        compound.func_74768_a("MaxPage", this.maxPage);
        compound.func_74768_a("Page", this.page);
        return compound;
    }

    protected IItemHandler createUnSidedHandler() {
        return this.getItemHandler();
    }

    @Override
    public TerribleChestItemHandler getItemHandler() {
        if (((Boolean)Config.COMMON.useSinglePageMode.get()).booleanValue()) {
            return TerribleChestItemHandler.create(this.containers, 0, 133);
        }
        int slots = (Integer)Config.COMMON.inventoryRows.get() * 9;
        return TerribleChestItemHandler.create(this.containers, () -> this.page * slots, () -> slots);
    }

    protected ITextComponent func_213907_g() {
        return TerribleChestTileEntity.CONTAINER_NAME;
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new TerribleChestContainer(id, playerInventory, this, this.chestData);
    }

    public boolean func_70300_a(PlayerEntity player) {
        World world = this.func_145831_w();
        BlockPos pos = this.func_174877_v();
        if (world == null || world.func_175625_s(pos) != this) {
            return false;
        }
        return !(player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) > 64.0);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.loadFromNbt(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        return this.saveToNbt(compound);
    }
}

