/*
 * Decompiled with CFR 0.152.
 */
package net.eidee.minecraft.terrible_chest.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.eidee.minecraft.terrible_chest.item.ItemStackContainer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class ItemStackContainerUtil {
    private ItemStackContainerUtil() {
    }

    public static Int2ObjectMap<ItemStackContainer> newContainers() {
        Int2ObjectOpenHashMap containers = new Int2ObjectOpenHashMap();
        containers.defaultReturnValue((Object)ItemStackContainer.EMPTY);
        return containers;
    }

    public static void saveAllItems(CompoundNBT nbt, Int2ObjectMap<ItemStackContainer> containers) {
        ListNBT list = new ListNBT();
        for (Int2ObjectMap.Entry entry : containers.int2ObjectEntrySet()) {
            int index = entry.getIntKey();
            ItemStackContainer item = (ItemStackContainer)entry.getValue();
            if (item.isEmpty()) continue;
            CompoundNBT compound = item.serializeNBT();
            compound.func_74768_a("Index", index);
            list.add((Object)compound);
        }
        nbt.func_218657_a("Items", (INBT)list);
    }

    public static void loadAllItems(CompoundNBT nbt, Int2ObjectMap<ItemStackContainer> containers) {
        ListNBT list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT compound = list.func_150305_b(i);
            int index = compound.func_74762_e("Index");
            ItemStackContainer item = ItemStackContainer.read(compound);
            if (item.isEmpty()) continue;
            containers.put(index, (Object)item);
        }
    }
}

