/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.blocks;

import endergeticexpansion.core.registry.EEBlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.EndDimension;
import net.minecraft.world.dimension.NetherDimension;
import net.minecraft.world.dimension.OverworldDimension;

public class BlockCorrock
extends Block {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);

    public BlockCorrock(Block.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return SoundType.field_211383_n;
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!this.isInProperDimension(worldIn)) {
            worldIn.func_175656_a(pos, this.getCorrockBlockForDimension(worldIn.func_201675_m()));
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (!this.isInProperDimension(worldIn.func_201672_e())) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 60 + worldIn.func_201674_k().nextInt(40));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_200132_m();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!this.isInProperDimension(context.func_195991_k())) {
            context.func_195991_k().func_205220_G_().func_205360_a(context.func_195995_a(), (Object)this, 60 + context.func_195991_k().func_201674_k().nextInt(40));
        }
        return this.func_176223_P();
    }

    public boolean isInProperDimension(World world) {
        if (this.func_176223_P().func_177230_c() == EEBlocks.CORROCK_OVERWORLD.get()) {
            return world.func_201675_m() instanceof OverworldDimension;
        }
        if (this.func_176223_P().func_177230_c() == EEBlocks.CORROCK_NETHER.get()) {
            return world.func_201675_m() instanceof NetherDimension;
        }
        if (this.func_176223_P().func_177230_c() == EEBlocks.CORROCK_END.get()) {
            return world.func_201675_m() instanceof EndDimension;
        }
        return false;
    }

    public BlockState getCorrockBlockForDimension(Dimension dimension) {
        switch (dimension.func_186058_p().func_186068_a()) {
            case 0: {
                return ((Block)EEBlocks.CORROCK_OVERWORLD.get()).func_176223_P();
            }
            case 1: {
                return ((Block)EEBlocks.CORROCK_END.get()).func_176223_P();
            }
            case -1: {
                return ((Block)EEBlocks.CORROCK_NETHER.get()).func_176223_P();
            }
        }
        return null;
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.NONE;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

