/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.blocks;

import endergeticexpansion.core.registry.EEBlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.EndDimension;
import net.minecraft.world.dimension.NetherDimension;
import net.minecraft.world.dimension.OverworldDimension;
import net.minecraftforge.common.ToolType;

public class BlockCorrockBlock
extends Block {
    public BlockCorrockBlock(Block.Properties properties) {
        super(properties);
    }

    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!this.isInProperDimension(worldIn) && !this.isSubmerged(worldIn, pos)) {
            worldIn.func_175656_a(pos, this.getCorrockBlockForDimension(worldIn.func_201675_m()));
        }
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return SoundType.field_211383_n;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.isInProperDimension(worldIn.func_201672_e())) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 60 + worldIn.func_201674_k().nextInt(40));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!this.isInProperDimension(context.func_195991_k())) {
            context.func_195991_k().func_205220_G_().func_205360_a(context.func_195995_a(), (Object)this, 60 + context.func_195991_k().func_201674_k().nextInt(40));
        }
        return this.func_176223_P();
    }

    public boolean isInProperDimension(World world) {
        if (this.func_176223_P().func_177230_c() == EEBlocks.CORROCK_BLOCK_OVERWORLD.get()) {
            return world.func_201675_m() instanceof OverworldDimension;
        }
        if (this.func_176223_P().func_177230_c() == EEBlocks.CORROCK_BLOCK_NETHER.get()) {
            return world.func_201675_m() instanceof NetherDimension;
        }
        if (this.func_176223_P().func_177230_c() == EEBlocks.CORROCK_BLOCK_END.get()) {
            return world.func_201675_m() instanceof EndDimension;
        }
        return false;
    }

    public BlockState getCorrockBlockForDimension(Dimension dimension) {
        switch (dimension.func_186058_p().func_186068_a()) {
            case 0: {
                return ((Block)EEBlocks.CORROCK_BLOCK_OVERWORLD.get()).func_176223_P();
            }
            case 1: {
                return ((Block)EEBlocks.CORROCK_BLOCK_END.get()).func_176223_P();
            }
            case -1: {
                return ((Block)EEBlocks.CORROCK_BLOCK_NETHER.get()).func_176223_P();
            }
        }
        return null;
    }

    public boolean isSubmerged(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150355_j || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j || worldIn.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150355_j || worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150355_j || worldIn.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150355_j || worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150355_j;
    }
}

