/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import endergeticexpansion.common.blocks.BlockCorrockCrown;
import endergeticexpansion.common.blocks.BlockCorrockCrownStanding;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;

public class BlockCorrockCrownWall
extends BlockCorrockCrown {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)0.0, (double)4.5, (double)14.0, (double)16.0, (double)12.5, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)0.0, (double)4.5, (double)0.0, (double)16.0, (double)12.5, (double)2.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)4.5, (double)0.0, (double)2.0, (double)12.5, (double)16.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)14.0, (double)4.5, (double)0.0, (double)16.0, (double)12.5, (double)16.0)));

    public BlockCorrockCrownWall(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!this.isInProperDimension(worldIn) && !this.isSubmerged(worldIn, pos)) {
            worldIn.func_175656_a(pos, (BlockState)this.getCorrockBlockForDimension(worldIn.func_201675_m()).func_206870_a((IProperty)FACING, worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)));
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    public BlockState getCorrockBlockForDimension(Dimension dimension) {
        switch (dimension.func_186058_p().func_186068_a()) {
            case 0: {
                return ((BlockCorrockCrownWall)EEBlocks.CORROCK_CROWN_OVERWORLD_WALL.get()).func_176223_P();
            }
            case 1: {
                return ((BlockCorrockCrownWall)EEBlocks.CORROCK_CROWN_END_WALL.get()).func_176223_P();
            }
            case -1: {
                return ((BlockCorrockCrownWall)EEBlocks.CORROCK_CROWN_NETHER_WALL.get()).func_176223_P();
            }
        }
        return null;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_185904_a().func_76220_a();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState BlockState2 = this.func_176223_P();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        World iworldreaderbase = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        Direction[] aDirection = context.func_196009_e();
        if (!this.isInProperDimension(context.func_195991_k())) {
            context.func_195991_k().func_205220_G_().func_205360_a(context.func_195995_a(), (Object)this, 60 + context.func_195991_k().func_201674_k().nextInt(40));
        }
        for (Direction Direction2 : aDirection) {
            Direction Direction1;
            if (!Direction2.func_176740_k().func_176722_c() || !(BlockState2 = (BlockState)BlockState2.func_206870_a((IProperty)FACING, (Comparable)(Direction1 = Direction2.func_176734_d()))).func_196955_c((IWorldReader)iworldreaderbase, blockpos) || iworldreaderbase.func_180495_p(blockpos.func_177972_a(((Direction)BlockState2.func_177229_b((IProperty)FACING)).func_176734_d())).func_177230_c() instanceof BlockCorrockCrownWall || iworldreaderbase.func_180495_p(blockpos.func_177972_a(((Direction)BlockState2.func_177229_b((IProperty)FACING)).func_176734_d())).func_177230_c() instanceof BlockCorrockCrownStanding) continue;
            return (BlockState)BlockState2.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.isInProperDimension(worldIn.func_201672_e())) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 60 + worldIn.func_201674_k().nextInt(40));
        }
        if (facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return facing.func_176734_d() == stateIn.func_177229_b((IProperty)FACING) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, WATERLOGGED});
    }
}

