/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.blocks.poise;

import endergeticexpansion.common.tileentities.TileEntityBolloomBud;
import endergeticexpansion.core.registry.EEBlocks;
import endergeticexpansion.core.registry.other.EETags;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockBolloomBud
extends Block {
    public static final BooleanProperty OPENED = BooleanProperty.func_177716_a((String)"opened");
    private static final VoxelShape INSIDE = BlockBolloomBud.func_208617_a((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)15.0, (double)12.5);
    protected static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)BlockBolloomBud.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), (VoxelShape)VoxelShapes.func_216384_a((VoxelShape)INSIDE, (VoxelShape[])new VoxelShape[0]), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    protected static final VoxelShape SHAPE_OPENED = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);

    public BlockBolloomBud(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)OPENED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return Block.func_208617_a((double)-16.0, (double)-16.0, (double)-16.0, (double)32.0, (double)32.0, (double)32.0);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150377_bs.getBlock() || block.func_203417_a(EETags.Blocks.END_PLANTABLE) || block.func_203417_a(EETags.Blocks.POISE_PLANTABLE);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.func_196955_c((IWorldReader)world, currentPos)) {
            boolean opened = (Boolean)stateIn.func_177229_b((IProperty)OPENED);
            return this.placePedals(world.func_201672_e(), currentPos, opened) && opened ? (BlockState)stateIn.func_206870_a((IProperty)OPENED, (Comparable)Boolean.valueOf(true)) : this.resetBud(world, currentPos);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.isValidGround(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos) && !BlockBolloomBud.isAcrossOrAdjacentToBud(worldIn, pos);
    }

    public boolean placePedals(World world, BlockPos pos, boolean opened) {
        if (!((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)OPENED)).booleanValue() && this.canPutDownPedals(world, pos)) {
            if (opened) {
                for (TileEntityBolloomBud.BudSide side : TileEntityBolloomBud.BudSide.values()) {
                    BlockPos sidePos = side.offsetPosition(pos);
                    if (!world.func_180495_p(sidePos).func_196952_d((IBlockReader)world, pos).func_197766_b()) continue;
                    world.func_175655_b(sidePos, true);
                }
            }
            return true;
        }
        if (opened) {
            return false;
        }
        return false;
    }

    public static boolean isAcrossOrAdjacentToBud(IWorldReader world, BlockPos pos) {
        Block block = (Block)EEBlocks.BOLLOOM_BUD.get();
        for (Direction directions : Direction.values()) {
            if (world.func_180495_p(pos.func_177967_a(directions, 2)).func_177230_c() != block) continue;
            return true;
        }
        BlockPos north = pos.func_177972_a(Direction.NORTH);
        BlockPos south = pos.func_177972_a(Direction.SOUTH);
        return world.func_180495_p(north.func_177974_f()).func_177230_c() == block || world.func_180495_p(south.func_177974_f()).func_177230_c() == block || world.func_180495_p(north.func_177976_e()).func_177230_c() == block || world.func_180495_p(south.func_177976_e()).func_177230_c() == block;
    }

    private boolean canPutDownPedals(World world, BlockPos pos) {
        for (TileEntityBolloomBud.BudSide sides : TileEntityBolloomBud.BudSide.values()) {
            BlockPos sidePos = sides.offsetPosition(pos);
            if (world.func_204610_c(sidePos).func_206888_e() && world.func_180495_p(sidePos).func_196952_d((IBlockReader)world, sidePos).func_197766_b()) continue;
            return false;
        }
        return true;
    }

    private BlockState resetBud(IWorld world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityBolloomBud) {
            ((TileEntityBolloomBud)world.func_175625_s(pos)).resetGrowing();
        }
        return this.func_176223_P();
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return (Boolean)p_220053_1_.func_177229_b((IProperty)OPENED) != false ? SHAPE_OPENED : SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_190946_v(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{OPENED});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityBolloomBud();
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

